package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.RoleVo;

/**
 * RoleService角色信息服务的适配器，该适配器主要用于自定义RBAC部分的实现，且一般来说不需要实现“写”性质的接口方法
 * @author yinwenjie
 */
public abstract class AbstractRoleServiceAdapter implements RoleService {
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.RoleService#create(com.bizunited.platform.rbac.server.vo.RoleVo)
   */
  @Override
  public RoleVo create(RoleVo role) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现RoleService.create接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.RoleService#update(com.bizunited.platform.rbac.server.vo.RoleVo)
   */
  @Override
  public RoleVo update(RoleVo role) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现RoleService.update接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.RoleService#enable(java.lang.String)
   */
  @Override
  public RoleVo enable(String roleId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现RoleService.enable接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.RoleService#disable(java.lang.String)
   */
  @Override
  public RoleVo disable(String roleId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现RoleService.disable接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.RoleService#bindRoles(java.lang.String, java.lang.String[])
   */
  @Override
  public void bindRoles(String userId, String[] roleNames) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现RoleService.bindRoles接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.RoleService#reBindRoles(java.lang.String, java.lang.String[])
   */
  @Override
  public void reBindRoles(String userId, String[] roleNames) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现RoleService.reBindRoles接口");
  }
}