package com.bizunited.platform.rbac.server.service;

import java.security.Principal;
import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;

/**
 * 功能服务相关接口.
 * @author yinwenjie
 * @version V1.0
 */
public interface CompetenceService {
  /**
   * 创建新功能，创建新功能是其URL信息必须是唯一的
   * @param comp 权限对象
   * @return CompetenceEntity
   */
  CompetenceVo create(CompetenceVo comp);
  /**
   * 批量添加，批量添加当然要进行批量验证
   * @param comps
   * @return
   */
  List<CompetenceVo> createAll(List<CompetenceVo> comps);
  /**
   * 修改功能
   * @param comp 权限对象
   * @return CompetenceEntity
   */
  CompetenceVo update(CompetenceVo comp);
  /**
   * 更改功能状态，以便实现功能的启用/禁用功能，注意，一旦父级功能的状态发生变更，那么其所有子级状态（多级）都会发生变化
   * @param id 权限id
   * @param flag 标识（true：启用操作；false：禁用操作）
   * @return 更改后的当前功能的基本信息将被返回
   */
  CompetenceVo updateStatus(String id, Boolean flag);  
  /**
   * 建立指定角色和指定功能的绑定关系
   * @param roleId 指定的角色编号信息
   * @param competenceId 指定的功能编号信息(可一个是一个或者多个)
   */
  void bindCompetence(String roleId , String competenceIds[]);

  /**
   * 取消指定角色和指定功能的绑定关系
   * @param roleId 指定的角色编号信息
   * @param competenceIds 指定的功能编号信息(可一个是一个或者多个)
   */
  void unbindCompetence(String roleId , String competenceIds[]);
  /**
   * 删除指定的功能，注意：如果当前功能存在下级关联功能，则不能进行删除
   * @param competenceId 指定的功能id
   */
  void deleteById(String competenceId);
  /**
   * 根据功能中的viewItem属性， 查询满足条件的所有功能信息（按照sortIndex进行排序）
   * @param viewItem 是否是功能菜单上的功能栏目
   */
  JSONArray findByViewItem(Boolean viewItem);
  
  /**
   * 根据功能中的viewItem属性、状态属性， 查询满足条件的所有功能信息（按照sortIndex进行排序）
   * @param viewItem 是否是功能菜单上的功能栏目
   * @param tstatus 状态信息，1：正常；0：禁用
   */
  JSONArray findByViewItemAndStatus(Boolean viewItem , Integer tstatus);
  /**
   * 该方法按照多个角色信息的name信息，查询能够被这些角色访问的处于指定状态的功能<br>
   * <b><这个功能是业务级访问者经常调用的接口的关键服务层支持/b>
   * 注：该接口是为了适应不同系统的不同菜单显示需求而设定的，
   * 表单引擎的原有菜单显示逻辑其实是调用findByViewItemAndRoleNamesAndStatus(Boolean viewItem , String[] roleNames , Integer status)
   * 其余的特殊菜单显示需求都需要传入Principal参数
   * @param viewItem 是否是功能菜单上的功能栏目 true：需要显示在菜单栏上的功能；false 不需要显示在菜单栏上的功能
   * @param roleNames 指定的一个或者多个角色name信息（如是：ADMIN、VISTOR）。必须传入一个，否则会直接返回null
   * @param status 状态（1正常/0禁用），这个状态信息不用必须，如果不传入则表示无论功能处于何种状态，都满足查询要求
   * @param principal 当前人信息
   * 
   * 组装菜单的处理逻辑
   * 1.返回null是yml文件中配置的ignoreMethodCheckRoles属性独有的方式，该角色的所有菜单都显示
   * 2.返回[] 是其他角色可能没有绑定菜单的情况
   * 3. 返回[{aaa:bbb},{xxx:yyy}] 是其他角色拥有的菜单
   */
  JSONArray findByViewItemAndRoleNamesAndStatus(Boolean viewItem , String[] roleNames , Integer status,Principal principal);
  /**
   * 该方法按照多个角色信息的name信息，查询能够被这些角色访问的处于指定状态的功能<br>
   * <b><这个功能是业务级访问者经常调用的接口的关键服务层支持/b>
   * @param viewItem 是否是功能菜单上的功能栏目 true：需要显示在菜单栏上的功能；false 不需要显示在菜单栏上的功能
   * @param roleNames 指定的一个或者多个角色name信息（如是：ADMIN、VISTOR）。必须传入一个，否则会直接返回null
   * @param status 状态（1正常/0禁用），这个状态信息不用必须，如果不传入则表示无论功能处于何种状态，都满足查询要求
   */
  JSONArray findByViewItemAndRoleNamesAndStatus(Boolean viewItem , String[] roleNames , Integer status);
  /**
   * 查询为当前URL设置的功能信息，注意，这里没有通过method进行过滤.
   * @param resource 权限串
   * @param useStatus 状态（正常/禁用）
   */
  List<CompetenceVo> findByResource(String resource , Integer status);
  /**
   * 判定当前操作者是否具有指定的resources所代表的URL功能的访问权限。
   * @param resources
   * @param userPrincipal
   * @return
   */
  JSONArray findByUrlResource(String[] resources , Principal userPrincipal);
  /**
   * 按id查询基本信息，这个基本信息不包括任何关联信息
   * @param competenceId
   * @return
   */
  CompetenceVo findById(String competenceId);
  /**
   * 这里只准对功能信息中viewItem为false的信息进行分页查询处理（查询条件也只有功能名）
   * @param comment 可能存在的功能名（功能备注） 
   * @param conditions 
   * @return
   */
  Page<CompetenceVo> findByConditions(String comment, Pageable pageable);
  /**
   * 查询目前数据库中所有功能信息
   * @return
   */
  List<CompetenceVo> findAll();
}