package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.UserVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

public interface UserService {
  /**
   * 创建一个用户，创建用户时只需要传入用户真实姓名、账号（一般是手机号）、联系电话<br>
   * 该方法只是用来创建用户基本信息的，还不会在方法中绑定角色，绑定角色使用独立的服务进行
   * @param userName 真实姓名（必须传入）
   * @param account 账号（一般是手机号）（必须传入）
   * @param phone 联系电话（可能传入）
   * @return 创建成功后新的用户信息将会返回
   */
  public UserVo create(UserVo user);
  /**
   * 对一个指定的用户信息进行修改，可以修改的信息非常有限，只有用户真实姓名、账号信息、联系电话等。
   * @param user 
   * @return
   */
  public UserVo update(UserVo user);
  /**
   * 修改密码，这个方法不用输入之前的原始密码，就可以进行密码修改<br>
   * 通常用于后台管理员重置密码
   * @param userId
   * @param newPassword 没有经过加密的新的密码
   * @return
   */
  public UserVo updatePassword(String userId, String newPassword);
  /**
   * 修改密码，这个方法需要输入之前的原始密码，才可以进行密码修改<br>
   * 通常用于用户自行修改密码
   * @param userId
   * @param newPassword 没有经过加密的新的密码
   * @param oldPassword 没有经过加密的原始密码
   * @return
   */
  public UserVo updatePassword(String userId, String newPassword , String oldPassword);
  /**
   * 启用指定的用户账户
   * @param account 用户账号，一般来说是他的手机号
   * @return
   */
  public UserVo enabled(String account);
  /**
   * 禁用指定的用户账户
   * @param account 用户账号，一般来说是他的手机号
   * @return
   */
  public UserVo disable(String account);
  /**
   * 查询当前用户信息（按照用户id去查），且包括当前用户已经绑定（包括间接绑定）的角色信息、用户组、组织机构和岗位
   * @param id 指定的用户id
   * @return 
   */
  public UserVo findDetailsById(String userId);
  /**
   * 按照指定的账户名，查询账户基本信息，该方法的查询不包括任何关联信息，例如角色信息。
   * @param account 账户名
   * @return
   */
  public UserVo findByAccount(String account);
  /**
   * 按照指定的手机号，查询账户基本信息，该方法的查询不包括任何关联信息，例如角色信息。
   * @param phone 指定的用户手机号
   * @return
   */
  public UserVo findByPhone(String phone);
  /**
   * 按条件搜索
   * @param userName 用户姓名
   * @param account 账号
   * @param useStatus 用户状态
   * @param pageable 分页设置信息
   * @return
   */
  public Page<UserVo> findByConditions(String userName, String account, Integer useStatus, Pageable pageable);
  /**
   * 预制控件查询本地数据库，查询用户基本信息
   * @param userId
   * @return
   */
  UserVo findByUserId(String userId);
  /**
   * 根据集合ids，查询多个用户信息
   */
  Set<UserVo> findByIds(List<String> ids);
}
