package com.bizunited.platform.rbac.server.service.vcode;

/**
 * 验证码服务，数字验证码、图片验证码等都算验证码
 * @author yinwenjie
 */
public interface ValidateCodeService {
  /**
   * .字母（纯大写）+数字性质的验证码的字符范围，这样定义主要是因为不能有混淆不清的字符出现，例如0和O
   */
  char[] VALIDATE_CHAR = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',  
         'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',  
         'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
  
  /**
   * .字母（包括大小写）+数字性质的验证码的字符范围，这样定义主要是因为不能有混淆不清的字符出现，例如0和O，l和1
   */
  char[] VALIDATE_IGNORE_CHAR = {'A','a', 'B','b', 'C','c', 'D','d', 'E','e', 'F','f', 'G','g', 'H','g', 'I','i', 'J','j',  
                                 'K','k', 'L', 'M','m', 'N','n', 'P','p', 'Q','q', 'R','r', 'S','s', 'T','t', 'U','u', 'V','v', 'W','w',  
                                 'X','x', 'Y','y', 'Z','z', '2', '3', '4', '5', '6', '7', '8', '9'};
  
  /**
   * 以用户编号为基础、以业务系统为编号、生成验证码。默认为6位的数字验证码，可以指定长度，如果指定长度则长度不能超过8位。</br>
   * 同时，也可以指定是十进制还是十六进制</br>
   * @param userid 用户标识
   * @param subSystem 指定的业务标识名，字符串可以不填，如果填写了，则只能包含字母
   * @param size 可以输入4-8，其它长度都不支持
   * @param hexType 验证码进制，支持十进制或者十六进制
   * @param timeout 验证码有效（单位毫秒），有效时间从这个验证码第一次生成时开始计算
   * @return 生成好的验证码将被返回。请注意，如果返回值中存在字母，则字母都是大写
   */
  public String generate(String userid , String subSystem , int size , ValidateCodeType codeType , int timeout);
  /**
   * 默认使用十进制数字验证码进行生成
   * @param userid 用户标识
   * @param subSystem 指定的业务标识名，字符串可以不填，如果填写了，则只能包含字母
   * @param size 可以输入4-8，其它长度都不支持
   * @param timeout 验证码有效（单位毫秒），有效时间从这个验证码第一次生成时开始计算
   * @return 生成好的验证码将被返回。请注意，如果返回值中存在字母，则字母都是大写
   */
  public String generate(String userid , String subSystem , int size, int timeout);
  /**
   * 默认使用6位的十进制数字验证码进行生成
   * @param userid 用户标识
   * @param subSystem 指定的业务标识名，字符串可以不填，如果填写了，则只能包含字母
   * @param timeout 验证码有效（单位毫秒），有效时间从这个验证码第一次生成时开始计算
   * @return 生成好的验证码将被返回。请注意，如果返回值中存在字母，则字母都是大写
   */
  public String generate(String userid , String subSystem, int timeout);
  /**
   * 使用业务系统定义的信息发送途径，将生成的验证码发送出去（一次发送一个手机号）
   * @param phoneNumber 接收验证码的手机号
   * @param userid 用户唯一的身份标识
   * @param subSystem 涉及到的业务系统
   * @param size 生成的验证码长度
   * @param hexType 验证码进制，目前支持十进制和十六进制的验证码
   * @param timeout 验证码超时时间（单位毫秒），如果验证码有效时间不足300秒，将补足300秒
   * </br>这是因为用户针对特定业务的短信验证码的发送频度有限制，限制时间为60秒，考虑到网络延迟差、短信网关延迟等问题，所以验证码有效时间最低为300秒
   * </br>另外请注意，一旦重复调用该接口且验证码本身超过了有效期，则发送是会生成新的验证码，否则就还是发送之前已经生成的验证码。
   * @return 
   */
  public String send(String phoneNumber , String userid , String subSystem , int size , ValidateCodeType codeType , int timeout);
  /**
   * 判定指定用户，针对指定业务，所给定的验证码，是否和系统生成的验证码匹配
   * @param userid 用户标识
   * @param subSystem 指定的业务标识名，字符串可以不填，如果填写了，则只能包含字母
   * @param original 用户传入的值
   * @return 如果匹配则返回true；其它情况下则返回false
   */
  public boolean match(String userid , String subSystem , String original);
  
  /**
   * 该方法用于查询指定用户标识、指定业务名下的验证码信息。如果验证码失效或者压根就没有验证码，则会返回null
   * @param userid 用户标识
   * @param subSystem 指定的业务标识名，字符串可以不填，如果填写了，则只能包含字母
   * @return 如果指定用户标识、指定业务名下存在验证码，则进行返回。其它情况则返回null；
   */
  public String findByUserAndSubSystem(String userid, String subSystem);
}