package com.bizunited.platform.rbac.server.service;

import java.util.List;

import com.bizunited.platform.rbac.server.vo.PositionVo;

/**
 * PositionService岗位信息服务的适配器，该适配器主要用于自定义RBAC部分的实现，且一般来说不需要实现“写”性质的接口方法
 * @author yinwenjie
 */
public abstract class AbstractPositionServiceAdapter implements PositionService {
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#create(com.bizunited.platform.rbac.server.vo.PositionVo)
   */
  @Override
  public PositionVo create(PositionVo positionEntity) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.create接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#update(com.bizunited.platform.rbac.server.vo.PositionVo)
   */
  @Override
  public PositionVo update(PositionVo positionEntity) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.update接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#updateStatus(java.lang.String)
   */
  @Override
  public PositionVo updateStatus(String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.updateStatus接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#bindOrgAndPosition(java.lang.String, java.lang.String)
   */
  @Override
  public void bindOrgAndPosition(String orgId, String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.bindOrgAndPosition接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#unbindOrgAndPosition(java.lang.String, java.lang.String)
   */
  @Override
  public void unbindOrgAndPosition(String orgId, String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.unbindOrgAndPosition接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#bindRoleAndPosition(java.lang.String, java.lang.String)
   */
  @Override
  public void bindRoleAndPosition(String roleId, String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.bindRoleAndPosition接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#bindRolesAndPosition(java.util.List, java.lang.String)
   */
  @Override
  public void bindRolesAndPosition(List<String> roleIds, String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.bindRolesAndPosition接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#unbindRoleAndPosition(java.lang.String, java.lang.String)
   */
  @Override
  public void unbindRoleAndPosition(String roleId, String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.unbindRoleAndPosition接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#unbindRolesAndPosition(java.util.List, java.lang.String)
   */
  @Override
  public void unbindRolesAndPosition(List<String> roleIds, String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.unbindRolesAndPosition接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#bindUsersAndPosition(java.util.List, java.lang.String)
   */
  @Override
  public void bindUsersAndPosition(List<String> userIds, String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.bindUsersAndPosition接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.PositionService#unbindUsersAndPosition(java.util.List, java.lang.String)
   */
  @Override
  public void unbindUsersAndPosition(List<String> userIds, String positionId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现PositionService.unbindUsersAndPosition接口");
  }
}