package com.bizunited.platform.rbac.server.service;

import java.util.List;

import com.bizunited.platform.rbac.server.vo.CompetenceVo;

/**
 * CompetenceService功能资源服务的适配器，该适配器主要用于自定义RBAC部分的实现，且一般来说不需要实现“写”性质的接口方法
 * @author yinwenjie
 *
 */
public abstract class AbstractCompetenceServiceAdapter implements CompetenceService {
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.CompetenceService#create(com.bizunited.platform.rbac.server.vo.CompetenceVo)
   */
  @Override
  public CompetenceVo create(CompetenceVo comp) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现CompetenceService.create接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.CompetenceService#createAll(java.util.List)
   */
  @Override
  public List<CompetenceVo> createAll(List<CompetenceVo> comps) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现CompetenceService.createAll接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.CompetenceService#update(com.bizunited.platform.rbac.server.vo.CompetenceVo)
   */
  @Override
  public CompetenceVo update(CompetenceVo comp) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现CompetenceService.update接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.CompetenceService#updateStatus(java.lang.String, java.lang.Boolean)
   */
  @Override
  public CompetenceVo updateStatus(String id, Boolean flag) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现CompetenceService.updateStatus接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.CompetenceService#bindCompetence(java.lang.String, java.lang.String[])
   */
  @Override
  public void bindCompetence(String roleId, String[] competenceIds) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现CompetenceService.bindCompetence接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.CompetenceService#unbindCompetence(java.lang.String, java.lang.String[])
   */
  @Override
  public void unbindCompetence(String roleId, String[] competenceIds) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现CompetenceService.unbindCompetence接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.CompetenceService#deleteById(java.lang.String)
   */
  @Override
  public void deleteById(String competenceId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现CompetenceService.deleteById接口");
  }
}