package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.OrganizationVo;

/**
 * OrganizationService组织机构信息服务的适配器，该适配器主要用于自定义RBAC部分的实现，且一般来说不需要实现“写”性质的接口方法
 * @author yinwenjie
 */
public abstract class AbstractOrganizationServiceAdapter implements OrganizationService {

  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#create(com.bizunited.platform.rbac.server.vo.OrganizationVo)
   */
  @Override
  public OrganizationVo create(OrganizationVo organization) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.create接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#update(com.bizunited.platform.rbac.server.vo.OrganizationVo)
   */
  @Override
  public OrganizationVo update(OrganizationVo organization) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.update接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#updateStatus(java.lang.String)
   */
  @Override
  public OrganizationVo updateStatus(String orgId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.updateStatus接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#bindParent(java.lang.String, java.lang.String)
   */
  @Override
  public void bindParent(String currentOrgId, String parentOrgId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.bindParent接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#unbindParent(java.lang.String)
   */
  @Override
  public void unbindParent(String currentOrgId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.unbindParent接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#bindUsers(java.lang.String, java.lang.String[])
   */
  @Override
  public void bindUsers(String currentOrgId, String[] userIds) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.bindUsers接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#unbindUser(java.lang.String)
   */
  @Override
  public void unbindUser(String userId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.unbindUser接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#unbindUser(java.lang.String, java.lang.String[])
   */
  @Override
  public void unbindUser(String currentOrgId, String[] userId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.unbindUser接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#bindRoles(java.lang.String, java.lang.String[])
   */
  @Override
  public void bindRoles(String currentOrgId, String[] roleIds) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.bindRoles接口");
  }
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.OrganizationService#unbindRole(java.lang.String[])
   */
  @Override
  public void unbindRole(String[] roleId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.unbindRole接口");
  }

  @Override
  public OrganizationVo findByCode(String code) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现OrganizationService.findByCode接口");
  }
}