package com.bizunited.platform.rbac.server.service;

import java.security.Principal;
import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;

/**
 * 功能服务相关接口.
 * @author yinwenjie
 * @version V1.0
 */
public interface CompetenceService {
  /**
   * 创建新功能，创建新功能是其URL信息必须是唯一的
   * @param comp 权限对象
   * @return CompetenceEntity
   */
  CompetenceVo create(CompetenceVo comp);
  /**
   * 批量添加，批量添加当然要进行批量验证
   * @param comps
   * @return
   */
  List<CompetenceVo> createAll(List<CompetenceVo> comps);
  /**
   * 修改功能
   * @param comp 权限对象
   * @return CompetenceEntity
   */
  CompetenceVo update(CompetenceVo comp);
  /**
   * 更改功能状态，以便实现功能的启用/禁用功能，注意，一旦父级功能的状态发生变更，那么其所有子级状态（多级）都会发生变化
   * @param id 权限id
   * @param flag 标识（true：启用操作；false：禁用操作）
   * @return 更改后的当前功能的基本信息将被返回
   */
  CompetenceVo updateStatus(String id, Boolean flag);  
  /**
   * 建立指定角色和指定功能的绑定关系
   * @param roleId 指定的角色编号信息
   * @param competenceId 指定的功能编号信息(可一个是一个或者多个)
   */
  void bindCompetence(String roleId , String competenceIds[]);

  /**
   * 取消指定角色和指定功能的绑定关系
   * @param roleId 指定的角色编号信息
   * @param competenceIds 指定的功能编号信息(可一个是一个或者多个)
   */
  void unbindCompetence(String roleId , String competenceIds[]);
  /**
   * 删除指定的功能，注意：如果当前功能存在下级关联功能，则不能进行删除
   * @param competenceId 指定的功能id
   */
  void deleteById(String competenceId);
  /**
   * 根据功能中的viewItem属性， 查询满足条件的所有功能信息（按照sortIndex进行排序）
   * @param viewItem 是否是功能菜单上的功能栏目
   */
  JSONArray findByViewItem(Boolean viewItem);
  
  /**
   * 根据功能中的viewItem属性、状态属性， 查询满足条件的所有功能信息（按照sortIndex进行排序）
   * @param viewItem 是否是功能菜单上的功能栏目
   * @param tstatus 状态信息，1：正常；0：禁用
   */
  JSONArray findByViewItemAndStatus(Boolean viewItem , Integer tstatus);
  /**
   * 查询指定的角色Name查询已绑定的功能信息，且这些功能状态符合查询的要求</br>
   * 1.该接口会对当前用户的角色名称与yml配置的管理员角色信息取交集，判定是否具有管理员角色,如果具有管理员权限，该接口直接返回约定的null</p>
   * 2.如果当前用户的角色没有包含管理员权限，那么就会查询当前用户所拥有的所有功能集</br>
   * 注：这里可能会存在当前用户还未分配功能权限的情况，如果在这里没有发现功能集competences有值，那么这里就会返回一个空的功能数组</p>
   * 3.查询指定父级功能下，能够被这些角色访问的viewItem为true的，处于正常状态的功能
   * @param viewItem 是否是功能菜单上的功能栏目 true：需要显示在菜单栏上的功能；false 不需要显示在菜单栏上的功能
   * @param roleNames 指定的一个或者多个角色name信息（如是：ADMIN、VISTOR）。必须传入一个，否则会直接返回null
   * @param status 状态（1正常/0禁用），这个状态信息不用必须，如果不传入则表示无论功能处于何种状态，都满足查询要求
   */
  JSONArray findByViewItemAndRoleNamesAndStatus(Boolean viewItem , String[] roleNames , Integer status);
  /**
   * 查询为当前URL设置的功能信息，注意，这里没有通过method进行过滤.
   * @param resource 权限串
   * @param useStatus 状态（正常/禁用）
   */
  List<CompetenceVo> findByResource(String resource , Integer status);
  /**
   * 判定当前操作者是否具有指定的resources所代表的URL功能的访问权限。
   * @param resources
   * @param userPrincipal
   * @return
   */
  JSONArray findByUrlResource(String[] resources , Principal userPrincipal);
  /**
   * 按id查询基本信息，这个基本信息不包括任何关联信息
   * @param competenceId
   * @return
   */
  CompetenceVo findById(String competenceId);
  /**
   * 这里只准对功能信息中viewItem为false的信息进行分页查询处理（查询条件也只有功能名）
   * @param comment 可能存在的功能名（功能备注） 
   * @param conditions 
   * @return
   */
  Page<CompetenceVo> findByConditions(String comment, Pageable pageable);
  /**
   * 查询目前数据库中所有功能信息
   * @return
   */
  List<CompetenceVo> findAll();
}