package com.bizunited.platform.rbac.server.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation.RelationType;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;

import java.util.Date;
import java.util.Set;

/**
 * 岗位信息的Vo性质模型描述
 * @author: yinwenjie
 * @date: 17/Jan/2019 09:53
 */
@SaturnEntity(name="PositionVo" , description="岗位信息")
public class PositionVo {
  /**
   * 抽象VO层模型的编号信息.
   */
  @SaturnColumn(pkColumn=true , insertable=true , updatable=false , nullable=true , description="主键")
  private String id;
  @SaturnColumn(description = "岗位的唯一编号", length = 128, nullable = false, unique = true)
  private String code;
  @SaturnColumn(description = "岗位名称", length = 64, nullable = false)
  private String name;
  @SaturnColumn(description = "所属组织id", nullable = true)
  @SaturnColumnRelation(type=RelationType.ManyToOne , mappedBy="positions")
  private OrganizationVo organization;
  @SaturnColumn(description = "已经绑定的角色信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , mappedBy="positions" , master=true)
  private Set<RoleVo> roles;
  @SaturnColumn(description = "已经绑定的用户信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , mappedBy="positions" , master=true)
  private Set<UserVo> users;
  @SaturnColumn(description = "岗位状态", nullable = false)
  private Integer tstatus;
  @SaturnColumn(description = "创建时间", nullable = false)
  private Date createTime = new Date();
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public OrganizationVo getOrganization() {
    return organization;
  }
  public void setOrganization(OrganizationVo organization) {
    this.organization = organization;
  }
  public Set<UserVo> getUsers() {
    return users;
  }
  public void setUsers(Set<UserVo> users) {
    this.users = users;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Set<RoleVo> getRoles() {
    return roles;
  }

  public void setRoles(Set<RoleVo> roles) {
    this.roles = roles;
  }
}
