package com.bizunited.platform.rbac.server.vo;

import java.util.Date;
import java.util.Set;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation.RelationType;
import com.bizunited.platform.saturn.engine.annotation.SaturnDefaultController;
import com.bizunited.platform.saturn.engine.annotation.SaturnDefaultController.Type;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;

/**
 * 用户信息的Vo性质描述
 * @author yinwenjie
 */
@SaturnEntity(description="用户信息" , name="UserVo")
public class UserVo {
  /**
   * 抽象VO层模型的编号信息.
   */
  @SaturnColumn(pkColumn=true , insertable=true , updatable=false , nullable=true , description="主键")
  private String id;
  
  @SaturnColumn(description="人员姓名", length = 64, nullable = false)
  private String userName;
  
  @SaturnColumn(description="用户账号登录信息", length = 64, nullable = false, unique = true)
  private String account;

  @SaturnColumn(description="身份证号码", length = 64, nullable = true)
  private String idcard;

  @SaturnColumn(description="人员主要联系电话", length = 64, nullable = true, unique = true)
  private String phone = "";
  
  @SaturnColumn(description="用户账号密码信息", length = 128, nullable = false)
  private String password;
  
  @SaturnColumn(description="创建时间", nullable = false)
  private Date createTime=new Date();
  
  @SaturnColumn(description="入职时间", nullable = false)
  private Date entryTime=new Date();
  
  @SaturnColumn(description="最后一次登录时间", nullable = true)
  private Date lastloginTime=new Date();
  
  @SaturnColumn(description="用户账号状态", nullable = false)
  private Integer useStatus = 1;
  
  @SaturnColumn(description="人员头像", length = 64, nullable = false)
  private String userHead = "";
  
  @SaturnColumn(description="人员性别" , nullable=true)
  @SaturnDefaultController(defaultType=Type.SELECT , defaultKeys="保密,男,女" , defaultValues="0,1,2")
  private Integer gender = 0;
  
  @SaturnColumn(description="所属组织机构信息" , nullable=true)
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=false , mappedBy="users")
  private Set<OrganizationVo> orgs;
  /** 角色和人员相关的. **/
  @SaturnColumn(description="角色和人员的关联信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=false , mappedBy="users")
  private Set<RoleVo> roles;
  
  @SaturnColumn(description="所属岗位信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=false , mappedBy="users")
  private Set<PositionVo> positions;

  @SaturnColumn(description="分组信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=false , mappedBy="users")
  private Set<UserGroupVo> groups;
  
  public String getUserName() {
    return userName;
  }
  public void setUserName(String userName) {
    this.userName = userName;
  }
  public String getAccount() {
    return account;
  }
  public void setAccount(String account) {
    this.account = account;
  }
  public String getPhone() {
    return phone;
  }
  public void setPhone(String phone) {
    this.phone = phone;
  }
  public String getPassword() {
    return password;
  }
  public void setPassword(String password) {
    this.password = password;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Date getEntryTime() {
    return entryTime;
  }
  public void setEntryTime(Date entryTime) {
    this.entryTime = entryTime;
  }
  public Date getLastloginTime() {
    return lastloginTime;
  }
  public void setLastloginTime(Date lastloginTime) {
    this.lastloginTime = lastloginTime;
  }
  public Integer getUseStatus() {
    return useStatus;
  }
  public void setUseStatus(Integer useStatus) {
    this.useStatus = useStatus;
  }
  public String getUserHead() {
    return userHead;
  }
  public void setUserHead(String userHead) {
    this.userHead = userHead;
  }
  public Integer getGender() {
    return gender;
  }
  public void setGender(Integer gender) {
    this.gender = gender;
  }
  public Set<OrganizationVo> getOrgs() {
    return orgs;
  }
  public void setOrgs(Set<OrganizationVo> orgs) {
    this.orgs = orgs;
  }
  public Set<PositionVo> getPositions() {
    return positions;
  }
  public void setPositions(Set<PositionVo> positions) {
    this.positions = positions;
  }
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public Set<RoleVo> getRoles() {
    return roles;
  }
  public void setRoles(Set<RoleVo> roles) {
    this.roles = roles;
  }
  public String getIdcard() {
    return idcard;
  }
  public void setIdcard(String idcard) {
    this.idcard = idcard;
  }
  public void setGroups(Set<UserGroupVo> groups) {
    this.groups = groups;
  }
  public Set<UserGroupVo> getGroups() {
    return groups;
  }
}