/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.crypto.password;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.password.PasswordEncoder;

public class Aes2PasswordEncoder
implements PasswordEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Aes2PasswordEncoder.class);
    private String secret = "abcdefgh12345678";
    private final String encodeType = "AES/CBC/PKCS5Padding";
    private boolean encodeHashAsBase64;

    public Aes2PasswordEncoder() {
    }

    public Aes2PasswordEncoder(String secret) {
        this.secret = secret;
    }

    public String encode(CharSequence rawPassword) {
        Validate.notBlank((CharSequence)rawPassword, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        byte[] bytes = rawPassword.toString().getBytes(StandardCharsets.UTF_8);
        byte[] key = this.secret.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec iv = new IvParameterSpec(key);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)keySpec, iv);
            byte[] enBytes = cipher.doFinal(bytes);
            return this.encode(enBytes);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String encode(byte[] bytes) {
        if (this.encodeHashAsBase64) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return String.valueOf(Hex.encode((byte[])bytes));
    }

    private byte[] decodeHB(String encodedPassword) {
        if (this.encodeHashAsBase64) {
            return Base64.getDecoder().decode(encodedPassword);
        }
        return Hex.decode((CharSequence)encodedPassword);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (StringUtils.isBlank((CharSequence)rawPassword) || StringUtils.isBlank((CharSequence)encodedPassword)) {
            return false;
        }
        String encode = this.encode(rawPassword);
        return encode.equals(encodedPassword);
    }

    public String decode(String encodedPassword) {
        Validate.notBlank((CharSequence)encodedPassword, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        byte[] encodedBytes = this.decodeHB(encodedPassword);
        byte[] key = this.secret.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(key);
            cipher.init(2, (Key)keySpec, iv);
            byte[] bytes = cipher.doFinal(encodedBytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void setEncodeHashAsBase64(boolean encodeHashAsBase64) {
        this.encodeHashAsBase64 = encodeHashAsBase64;
    }
}

