package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.RoleVo;

import java.util.List;
import java.util.Set;

public interface RoleService {
  /**
   * 该方法用于添加一个角色信息，这个角色信息的名字必须是唯一的
   * @param role 新的角色信息
   * @return
   */
  RoleVo create(RoleVo role);
  /**
   * 修改一个指定的角色信息，注意配置在roles.deleteDeny属性的信息不能进行修改操作<br>
   * 且指定的一个角色只能修改角色的comment信息
   * 
   * @param role 指定的修改信息
   * @return
   */
  RoleVo update(RoleVo role);
  /**
   * 重新启用某一个指定的角色信息
   * 
   * @param roleId
   * @return
   */
  RoleVo enable(String roleId);
  /**
   * 禁用某一个指定的角色信息（相当于删除）<br>
   * 只是系统中不能真正的删除某一个角色，只能是将这个角色作废掉或者恢复正常状态
   * 
   * @param roleId
   * @return
   */
  RoleVo disable(String roleId);
  /**
   * 给指定id的用户绑定角色
   * @param userId 
   * @param roleNames 
   * @return 
   */
  void bindRoles(String userId, String[] roleNames);
  /**
   * 给指定id的用户重新进行角色绑定，也就是说以前的绑定信息就失效了，按照最新给定的角色名进行角色绑定
   * @param userId 指定的用户id信息
   * @param roleNames 给定的角色名
   */
  void reBindRoles(String userId, String[] roleNames);
  /**
   * 查询指定的角色信息，按照角色的数据层编号查询
   * @param roleId 角色编号
   * @return
   */
  RoleVo findById(String roleId);
  /**
   * 查询指定的用户所绑定的角色信息(只包括角色基本信息)，
   * 这些角色信息包括了用户自己绑定的、用户可能所在用户组绑定的、用户所在组织机构绑定的，甚至第三方系统的，等等
   * @return
   */
  List<RoleVo> findAllByUserId(String userId);
  /**
   * 查询指定的功能描述所绑定的角色信息(只包括角色基本信息)
   * @param competenceId 功能描述信息
   * @return
   */
  List<RoleVo> findByCompetenceId(String competenceId);
  /**
   * 查询符合角色状态的信息
   * 
   * @param useStatus 目前只有两种状态的枚举，一种是正常另外一种是作废
   * @return
   */
  List<RoleVo> findByStatus(Integer useStatus);
  /**
   * 查询目前系统中所有的角色信息，无论这些角色信息是否可用（但是只包括角色的基本信息）
   * @return
   */
  List<RoleVo> findAll();

  /**
   * 查询多个角色信息
   * @param ids
   * @return
   */
  Set<RoleVo> findByIds(List<String> ids);

  /**
   * 根据code查询角色
   * @param code
   * @return
   */
  RoleVo findByCode(String code);
}
