package com.bizunited.platform.rbac.server.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.bizunited.platform.rbac.server.vo.UserGroupVo;

import java.util.List;
import java.util.Set;

public interface UserGroupService {
  /**
   * 新增用户组
   * @param userGroup 用户组信息
   * @return
   */
  UserGroupVo create(UserGroupVo userGroup);

  /**
   * 修改用户组信息，只能修改用户组描述
   * @param userGroup 用户组相关信息
   * @return
   */
  UserGroupVo update(UserGroupVo userGroup);

  /**
   * 修改用户组状态：启用、禁用
   * @param groupId 用户组id
   * @return
   */
  UserGroupVo updateStatus(String groupId);

  /**
   * 用户组与用户绑定(可以绑定多个用户id，不过只要有一个用户id绑定错误，则整个绑定过程失败)
   * @param groupId 用户组id
   * @param userIds 用户id
   * @return
   */
  void bindUser(String groupId, String userIds[]);

  /**
   * 用户组与用户解除绑定(可以绑定多个用户id，不过只要有一个用户id绑定错误，则整个绑定过程失败)
   * @param groupId 用户组id
   * @param userID  用户id
   * @return
   */
  void unBindUser(String groupId, String userIds[]);

  /**
   * 用户组与角色绑定(可以绑定多个角色id，不过只要有一个角色id绑定错误，则整个绑定过程失败)
   * @param groupId 用户组id
   * @param roleIds  角色id
   */
  void bindRole(String groupId, String roleIds[]);

  /**
   * 用户组与角色解除绑定(可以解绑多个角色id，不过只要有一个角色id绑定错误，则整个绑定过程失败)
   * @param groupId 用户组id
   * @param roleId  角色id
   */
  void unBindRole(String groupId, String roleIds[]);

  /**
   * 按照指定的人员数据库编号，查询人员已经绑定的一个或者多个用户组信息。<p>
   * 注意：用户组信息中包括了用户组已经绑定的角色信息。
   * @param userId
   * @return
   */
  Set<UserGroupVo> findByUserId(String userId);

  /**
   * 根据用户组名称或者用户组状态查询
   * @param groupName 用户组名称
   * @param status    用户组状态
   * @return
   */
  Page<UserGroupVo> findByCondition(String groupName, Integer status, Pageable pageable);
  /**
   * 查询用户组详情
   *
   * @param id 用户组id
   * @return
   */
  Set<UserGroupVo> findDetailsById(String id);

  /**
   * 查询多个用户组信息
   * @param ids
   * @return
   */
  Set<UserGroupVo> findByIds(List<String> ids);
}
