package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.ButtonVo;

import java.security.Principal;
import java.util.Set;

/**
 * 按钮的相关接口定义
 * @author: zengxingwang
 * @date: 2020/1/13 14:43
 */
public interface ButtonService {

  /**
   * 建立指定按钮和指定接口的绑定关系
   * @param buttonId
   * @param competenceIds
   */
  void bindCompetences(String buttonId, String[] competenceIds);

  /**
   * 取消指定按钮和指定接口的绑定关系
   * @param buttonId
   * @param competenceIds
   */
  void unbindCompetences(String buttonId, String[] competenceIds);

  /**
   * 根据按钮id查询按钮信息
   * @param buttonId
   * @return
   */
  ButtonVo findDateilsById(String buttonId);

  /**
   * 根据用户ID查询用户的按钮权限
   * @param userId
   * @return
   */
  Set<ButtonVo> findByUserId(String userId);

  /**
   * 创建按钮
   * @param button
   * @return
   */
  ButtonVo create(ButtonVo button);

  /**
   * 批量创建按钮
   * @param buttons
   * @return
   */
  void batchCreate(Set<ButtonVo> buttons);

  /**
   * 修改按钮信息
   * @param button
   * @return
   */
  ButtonVo update(ButtonVo button);

  /**
   * 根据id删除按钮
   * @param id
   */
  void deleteById(String id);

  /**
   * 根据id批量删除按钮
   * @param ids
   */
  void batchDelete(String[] ids);

  /**
   * 根据菜单ID查询按钮
   * @param competenceId
   * @return
   */
  Set<ButtonVo> findByCompetenceId(String competenceId);

  /**
   * 根据角色code查询关联的按钮
   * @param roleCode
   * @return
   */
  Set<ButtonVo> findByRoleCode(String roleCode);

  /**
   * 查询当前登录用户的按钮权限，如果当前登录用户有忽略权限的按钮，那就返回所有的权限按钮
   * @param principal
   * @return
   */
  Set<ButtonVo> findByCurrentUser(Principal principal);
}
