package com.bizunited.platform.rbac.server.service.ccode;

/**
 * 校验码管理服务定义，负责生成、验证，在登录时专用的校验码信息（这种校验码信息最主要的作用是专门防止机器人登录的）
 * @author yinwenjie
 */
public interface CheckCodeService {
  /**
   * .为当前指定用户标识的登录操作，生成一个新的校验码，并将校验码图片进行返回（png格式）
   * .校验码充最后一次调用该方法生成开始计算有5分钟超时时间。
   * @param userid 指定的用户标识（一般以当前HTTP请求的回话session id来代替）
   * @param size 验证码的字体大小
   * @param width 验证码图片的宽度（单位像素）
   * @param height 验证码图片的高度（单位像素）
   * @return 生成的图片将会被返回（PNG格式的图片）
   */
  public byte[] generate(String userid , int size , int width , int height);
  
  /**
   * .为当前指定用户标识的登录操作，生成一个新的校验码，并将校验码图片的base64编码格式进行返回（png格式）
   * .校验码充最后一次调用该方法生成开始计算有5分钟超时时间。
   * @param userid 指定的用户标识（一般以当前HTTP请求的回话session id来代替）
   * @param size 验证码的字体大小
   * @param width 验证码图片的宽度（单位像素）
   * @param height 验证码图片的高度（单位像素）
   * @return 生成的图片的base64编码格式，将会被返回（PNG格式的图片）
   */
  public String generateByBase64(String userid , int size , int width , int height);
  
  /**
   * .验证当前登录操作会话输入的验证码信息是否和之前为这个会话生成的验证码一样、
   * @param userid 指定的用户会话标识
   * @param original 用户从外部输入的验证码信息
   * @return 如果输入的验证码，和之前为这个用户会话生成的验证码匹配（不区分大小写），则返回true；其它情况返回false
   */
  public boolean match(String userid , String original);
}