/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.service.redis;

import com.bizunited.platform.rbac.server.service.redis.RedisMutexService;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RedisMutexServiceDefaultImpl
implements RedisMutexService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisMutexServiceDefaultImpl.class);
    private static final String REDIS_ERROR = "RedisMutexService key is null!!";
    @Autowired
    private RedissonClient redissonClient;

    @Override
    public void lock(String key) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        rlock.lock();
    }

    @Override
    public boolean tryLock(String key, TimeUnit unit, int timeout) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        Validate.notNull((Object)((Object)unit), (String)REDIS_ERROR, (Object[])new Object[0]);
        Validate.isTrue((timeout > 0 ? 1 : 0) != 0, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        try {
            return rlock.tryLock((long)timeout, unit);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void unlock(String key) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        rlock.unlock();
    }

    @Override
    public boolean islock(String key) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        return rlock.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndIncrement(String code, long min) {
        Validate.notNull((Object)code, (String)"code\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        long currentMin = min <= 0L ? 0L : min;
        String lockCode = StringUtils.join((Object[])new String[]{"_async_", code});
        long currentValue = 0L;
        try {
            this.lock(lockCode);
            currentValue = this.redissonClient.getAtomicLong(code).getAndIncrement();
            if (currentValue < currentMin) {
                this.redissonClient.getAtomicLong(code).set(currentMin + 1L);
                currentValue = currentMin;
            }
        }
        finally {
            this.unlock(lockCode);
        }
        return currentValue;
    }

    @Override
    public String getAndIncrement(String code, long min, Integer mixStrLen) {
        Validate.isTrue((mixStrLen > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6570\u5b57\u683c\u5f0f\u5316\u7684\u65f6\u5019\uff0c\u8bbe\u5b9a\u7684\u683c\u5f0f\u5316\u6700\u5c0f\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        long current = this.getAndIncrement(code, min);
        String currentValue = String.valueOf(current);
        int currentStrLen = currentValue.length();
        if (currentStrLen >= mixStrLen) {
            return currentValue;
        }
        char[] fillChars = new char[mixStrLen.intValue()];
        Arrays.fill(fillChars, 0, (int)mixStrLen, '0');
        DecimalFormat format = new DecimalFormat(new String(fillChars));
        return format.format(current);
    }

    @Override
    public void setMCode(String mapName, String mapKey, String content, long min) {
        Validate.notBlank((CharSequence)mapName, (String)"\u8fdb\u884credission client\u865a\u62dfmap\u7ed3\u6784\u64cd\u4f5c\u65f6\uff0cmap name\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mapKey, (String)"\u8fdb\u884credission client\u865a\u62dfmap\u7ed3\u6784\u64cd\u4f5c\u65f6\uff0cmap name\u4e0b\u7684key\u503c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)content, (String)"\u8fdb\u884credission client\u865a\u62dfmap\u7ed3\u6784\u64cd\u4f5c\u65f6\uff0cmap name\u4e0b\u7684key\u503c\u5bf9\u5e94\u7684value\u5185\u5bb9\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        if (min <= 0L) {
            throw new IllegalArgumentException("\u8fdb\u884credission client\u865a\u62dfmap\u7ed3\u6784\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u8bbe\u5b9a\u4e00\u4e2a\u6709\u6548\u7684\u8fc7\u671f\u65f6\u95f4!!");
        }
        RMapCache currentMap = this.redissonClient.getMapCache(mapName);
        Validate.notNull((Object)currentMap, (String)"\u672a\u83b7\u53d6\u5230redis\u76f8\u5173\u4fe1\u606f\uff0c", (Object[])new Object[0]);
        currentMap.put((Object)mapKey, (Object)content, min, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getMCode(String mapName, String mapKey) {
        if (StringUtils.isBlank((CharSequence)mapName)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)mapKey)) {
            return null;
        }
        RMapCache currentMap = this.redissonClient.getMapCache(mapName);
        if (currentMap == null) {
            return null;
        }
        Object currentValue = currentMap.get((Object)mapKey);
        return currentValue == null ? null : currentValue.toString();
    }
}

