package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.UserGroupVo;

/**
 * UserGroupService用户组信息服务的适配器，该适配器主要用于自定义RBAC部分的实现，且一般来说不需要实现“写”性质的接口方法
 * @author yinwenjie
 */
public abstract class AbstractUserGroupServiceAdapter implements UserGroupService {
  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.UserGroupService#create(com.bizunited.platform.rbac.server.vo.UserGroupVo)
   */
  @Override
  public UserGroupVo create(UserGroupVo userGroup) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserGroupService.create接口");
  }

  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.UserGroupService#update(com.bizunited.platform.rbac.server.vo.UserGroupVo)
   */
  @Override
  public UserGroupVo update(UserGroupVo userGroup) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserGroupService.update接口");
  }

  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.UserGroupService#updateStatus(java.lang.String)
   */
  @Override
  public UserGroupVo updateStatus(String groupId) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserGroupService.updateStatus接口");
  }

  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.UserGroupService#bindUser(java.lang.String, java.lang.String[])
   */
  @Override
  public void bindUser(String groupId, String[] userIds) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserGroupService.bindUser接口");
  }

  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.UserGroupService#unBindUser(java.lang.String, java.lang.String[])
   */
  @Override
  public void unBindUser(String groupId, String[] userIds) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserGroupService.unBindUser接口");
  }

  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.UserGroupService#bindRole(java.lang.String, java.lang.String[])
   */
  @Override
  public void bindRole(String groupId, String[] roleIds) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserGroupService.bindRole接口");
  }

  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.UserGroupService#unBindRole(java.lang.String, java.lang.String[])
   */
  @Override
  public void unBindRole(String groupId, String[] roleIds) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserGroupService.unBindRole接口");
  }
}
