package com.bizunited.platform.rbac.server.service.sms;

/**
 * 技术中台底层的服务接口：由于技术中台内部在一些场景下，存在发送短信的要求。例如发送用户操作码、发送登录验证码、或者用于“验证码”控件</p>
 * 但一个事实是，当技术中台利用到实际项目中时，由于这些项目使用的短信供应商是不同的，造成短信发送的实际代码存在较大差异。</p>
 * 
 * 为了保证对这些实际短信发送功能的兼容性，技术中台的底层定义了这个接口——当编写具体短信发送功能代码时，需要实现这个接口（或者继承该接口的适配器：RbacSmsServiceAdapter），
 * 实例如下：</p>
 * 
 * <code>
 * // 这个接口代表业务系统代码中定义的，使用阿里云的短信服务发送短信的接口</br>
 * public interface AliSmsService {</br>
 * &nbsp;&nbsp;public void send(String[] phoneNumbers , String templateCode);</br>
 * }</br>
 * </code></p>
 * 
 * <code>
 * // 这是业务系统中对于AliSmsService的实现</br>
 * // 请注意它不但实现了AliSmsService接口，还继承了技术中台底层实现的短信服务定义的适配器，并覆盖实现了后者中所有的方法</br>
 * // 这样一来技术中台内部需要使用短信服务的功能就可以真实实现短信发送了</br>
 * public class AliSmsServiceImpl extends SmsServiceAdapter implements AliSmsService {</br>
 * &nbsp;&nbsp;</br>
 * }</br>
 * </code>
 * @author yinwenjie 
 */
public interface SmsService {
  /**
   * 技术中台使用的短信发送功能的定义
   * @param phone 指定发送的手机号
   * @param content 本次发送的短信内容 
   * @param smsType 短信内容的性质，请参考SmsTypeEnums枚举中的注释说明
   */
  public void sendSms(String phone , String content , SmsTypeEnums smsType);
}