package com.bizunited.platform.rbac.server.service.redis;

import java.util.concurrent.TimeUnit;

/**
 * 基于redssion的分布式排它锁服务定义
 * @author yinwenjie
 */
public interface RedisMutexService {
  /**
   * 按照指定的key值，启动基于redis的分布式锁。使用该方式
   * @param key
   */
  void lock(String key);
  /**
   * 尝试按照指定的key值，基于redis获得分布式锁下的操作权。
   * @param key 
   * @param unit 尝试时间的单位
   * @param timeout 尝试时间
   * @return 在尝试获取锁的阶段，该线程将进入阻塞状态，一旦获取到锁（返回true）或者尝试超过了指定时间（返回false），线程将打开阻塞状态
   */
  boolean tryLock(String key, TimeUnit unit ,int timeout);
  /**
   * 使用该方法参照指定的key值，基于redis释放本进程对分布式锁的所有权
   * @param lockKey
   */
  void unlock(String key);
  /**
   * 判断当前进程是否基于指定的key值，拥有对应的分布式锁下的操作权限
   * @param key 
   * @return
   */
  boolean islock(String key);
  /**
   * 使用Redis客户端，在服务器完成一次原子性质的获取和增加操作
   * @param code 
   * @return
   */
  long getAndIncrement(String code , long min);
  /**
   * TODO 注释未写
   * @param code
   * @param min
   * @param mixStrLen
   * @return
   */
  String getAndIncrement(String code , long min , Integer mixStrLen);
  
  /**
   * 使用redission client提供的虚拟map结构，按照mapName为单位，设定key-value键值对。</br>
   * 并且后者这个键值对存储有效期为ming（单位毫秒）
   * @param id 
   * @param code 
   * @param min 
   * @return 
   */
  void setMCode(String mapName , String mapKey , String content , long min);
  /**
   * 基于redission client提供的虚拟map结构，按照mapName为单位，获取指定的key可能对应的值。<br>
   * @param mapName 
   * @param mapKey 
   * @return 有两种情况会返回null：mapName对应的虚拟map结构中，并没有设定指定的key值；另一种是之前设定了，但是已经到了有效期
   */
  String getMCode(String mapName , String mapKey);
}