package com.bizunited.platform.rbac.server.vo;

import java.util.Date;
import java.util.Set;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation.RelationType;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;

/**
 * 系统功能信息的数据持久层描述
 * @author yinwenjie
 * @version V2.0
 */
@SaturnEntity(description="系统功能信息" , name="CompetenceVo")
public class CompetenceVo {
  /**
   * 抽象VO层模型的编号信息.
   */
  @SaturnColumn(pkColumn=true , insertable=true , updatable=false , nullable=true , description="主键")
  private String id;
  /** 权限URL串. **/
  @SaturnColumn(description="权限URL串" , nullable=false)
  private String resource = "";
  /**
   * 涉及的方法描述<br>
   * 例如：POST或者POST|GET|DELETE
   */
  @SaturnColumn(description="涉及的方法描述" , length=64 , nullable = false)
  private String methods = "";
  /** 创建时间. **/
  @SaturnColumn(description="创建时间", nullable = false)
  private Date createDate = new Date();
  /** 修改时间. **/
  @SaturnColumn(description="修改时间", nullable=false)
  private Date modifyDate = new Date();
  /** 状态 1正常, 0禁用（枚举）. **/
  @SaturnColumn(description="功能状态" , nullable = false)
  private Integer tstatus = 1;
  /** 功能备注（功能中文名）. **/
  @SaturnColumn(description="功能备注（功能中文名）", length=256, nullable = false)
  private String comment = "";
  /**
   * 当前功能项是否显示在菜单树中
   */
  @SaturnColumn(description="功能项是否显示在菜单树中", nullable=false)
  private Integer viewItem = 0;
  /**
   * 功能排序信息，数字越大排序越靠后
   */
  @SaturnColumn(description="功能排序信息", nullable=false)
  private Integer sortIndex = 100;
  /**
   * 图表标识信息
   */
  @SaturnColumn(description="图表标识", length=32 , nullable=true)
  private String icon = "";
  /**
   * 这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径
   */
  @SaturnColumn(description="带有匹配符的动态路径" , nullable=false)
  private Integer extractUri = 0;
  /**
   * 接口标签，主要来自swagger api上注解的标签
   */
  @SaturnColumn(description="接口标签")
  private String tag;
  /**
   * 权限对应的角色信息
   */
  @SaturnColumn(description="权限对应的角色信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , mappedBy="competences")
  private Set<RoleVo> roles;
  /**
   * 当前功能对应的父级功能，注意可能没有。如果没有父级功能，说明当前这个功能可能就是一个最顶级的父级功能
   */
  @SaturnColumn(description="当前功能对应的父级功能", nullable=true)
  @SaturnColumnRelation(type=RelationType.ManyToOne)
  private CompetenceVo parent;
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getResource() {
    return resource;
  }
  public void setResource(String resource) {
    this.resource = resource;
  }
  public String getMethods() {
    return methods;
  }
  public void setMethods(String methods) {
    this.methods = methods;
  }
  public Date getCreateDate() {
    return createDate;
  }
  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }
  public Date getModifyDate() {
    return modifyDate;
  }
  public void setModifyDate(Date modifyDate) {
    this.modifyDate = modifyDate;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }
  public Integer getViewItem() {
    return viewItem;
  }
  public void setViewItem(Integer viewItem) {
    this.viewItem = viewItem;
  }
  public Integer getSortIndex() {
    return sortIndex;
  }
  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
  public String getIcon() {
    return icon;
  }
  public void setIcon(String icon) {
    this.icon = icon;
  }
  public String getTag() {
    return tag;
  }
  public void setTag(String tag) {
    this.tag = tag;
  }
  public Integer getExtractUri() {
    return extractUri;
  }
  public void setExtractUri(Integer extractUri) {
    this.extractUri = extractUri;
  }
  public Set<RoleVo> getRoles() {
    return roles;
  }
  public void setRoles(Set<RoleVo> roles) {
    this.roles = roles;
  }
  public CompetenceVo getParent() {
    return parent;
  }
  public void setParent(CompetenceVo parent) {
    this.parent = parent;
  }
}