package com.bizunited.platform.rbac.server.service;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.rbac.server.vo.OrganizationVo;

import java.util.List;
import java.util.Set;

/**
 * @author yinwenjie
 */
public interface OrganizationService {
  /**
   * 添加组织机构
   * @param organization 组织机构相关信息
   * @return
   */
  OrganizationVo create(OrganizationVo organization);

  /**
   * 添加组织机构
   * @param organization 组织机构相关信息
   * @return
   */
  OrganizationVo update(OrganizationVo organization);

  /**
   * 更新用户的主组织机构
   * @param userId
   * @param orgId
   */
  void updateUserMainOrg(String userId, String orgId);

  /**
   * 组织机构状态---启用、禁用
   * @param orgId 组织机构id
   * @return
   */
  OrganizationVo updateStatus(String orgId);

  /**
   * 对一个指定的currentOrgId进行其父级组织机构parentOrgId的绑定操作（原有currentOrgId的父级信息将会被取消）
   * @param currentOrgId
   * @param parentOrgId
   */
  public void bindParent(String currentOrgId, String parentOrgId);

  /**
   * 对一个指定的currentOrgId取消其当前父级关系的绑定信息
   * @param currentOrgId
   */
  public void unbindParent(String currentOrgId);

  /**
   * 将指定组织机构（currentOrgId）和指定的一个/多个用户数据编号（userId）形成绑定关系——一个用户只能属于一个组织机构<p>
   * 注意，目前一个人员可以和多个组织机构进行绑定，但是呢一个人员最多只能和一个组织机构绑定一次
   * @param currentOrgId
   * @param userIds      指定的一个/多个用户数据编号
   */
  public void bindUsers(String currentOrgId, String[] userIds);

  /**
   * 解除指定用户和任意组织机构的绑定关系
   * @param userId
   */
  public void unbindUser(String userId);

  /**
   * 解除指定用户和指定组织机构的绑定关系
   * @param currentOrgId 指定的组织机构数据库编号
   * @param userId       指定的人员编号
   */
  public void unbindUser(String currentOrgId, String[] userId);

  /**
   * 将指定组织机构（currentOrgId）和指定的一个/多个用户数据编号（userId）形成绑定关系——一个用户只能属于一个组织机构
   * @param currentOrgId
   * @param roleIds      指定的一个/多个用户数据编号
   */
  public void bindRoles(String currentOrgId, String[] roleIds);

  /**
   * 解除指定用户和任何组织机构的绑定关系
   * @param roleId
   */
  public void unbindRole(String[] roleId);


  /**
   * 查询目前没有指定父级组织机构的所有组织机构信息，无论其状态是否正常（status无论什么值）<br>
   * 注意：(查询的信息不包括任何关联信息)
   *
   * @return
   */
  public List<OrganizationVo> findByNullParent();

  /**
   * 查询指定父级组织机构下的所有子级组织机构信息，无论其状态是否正常（status无论什么值）<br>
   * 注意：(查询的信息不包括任何关联信息)
   * @return
   */
  public List<OrganizationVo> findByParent(String parentId);

  /**
   * 查询目前没有指定父级组织机构的所有组织机构信息，并且依据其状态进行查询<br>
   * 注意：(查询的信息不包括任何关联信息)
   * @return
   */
  public List<OrganizationVo> findByNullParentAndStatus(Integer status);

  /**
   * 查询指定父级组织机构下的所有子级组织机构信息，并且依据其状态进行查询<br>
   * 注意：(查询的信息不包括任何关联信息)
   * @return
   */
  public List<OrganizationVo> findByParentAndStatus(String parentId, Integer status);

  /**
   * 根据组织机构名称，查询这个组织机构以及这个组织（这些组织机构）对应的所有父级结构信息<br>
   * 由于这里的构造是无限级别的，所以需要在方法内做递归处理，且直接返回json信息
   * @param orgName 组织机构名称信息
   * @return
   */
  public JSONArray findByOrgName(String orgName);

  /**
   * 根据指定的用户信息，查询这个用户所绑定的组织机构信息(一个或者多个)，以及这个组织机构的所有父级组织机构信息
   * 由于这里的构造是无限级别的，所以需要在方法内做递归处理，且直接返回json信息。<p>
   * 注意：这些组织机构的返回信息中，包括了组织机构已经绑定的角色信息。<p>
   * 一定注意该方法和RoleService.findByUserId(String userId)方法在实现逻辑上的区别。
   * @return
   */
  public JSONArray findByUserId(String userId);

  /**
   * 查询指定父级组织以及父级组织机构下的所有子级组织机构信息，无论其状态是否正常（status无论什么值）", notes = "注意：包括关联的用户信息
   * @param id 组织机构id
   * @return
   */
  public OrganizationVo findDetailsById(String id);

  /**
   * 查询指定组织机构的所有可以绑定的组织机构
   * @param orgId
   * @return
   */
  public Object[] findUnbindOrgById(String orgId);

  /**
   * 查询所有组织机构
   * @return
   */
  public List<OrganizationVo> findAll();

  /**
   * 预制控件查询，查询用户组织机构信息
   * @param userId
   * @return
   */
  Set<OrganizationVo> findOrgByUserId(String userId);

  /**
   * 查询多个组织信息
   * @param ids
   * @return
   */
  Set<OrganizationVo> findByIds(List<String> ids);

  /**
   * 查询所有根节点组织机构
   * @return
   */
  List<OrganizationVo> findRootOrg();

  /**
   * 树结构查询-查询这个组织机构以及这个组织机构对应的所有子级结构信息
   * @param id
   * @return
   */
  OrganizationVo findById(String id);


  /**
   * 根据组织机构名称实现模糊查询
   * @param orgName
   * @return
   */
  Set<OrganizationVo> findByOrgNameLike(String orgName);

  /**
   * 根据组织机构查询
   * @param code
   * @return
   */
  OrganizationVo findByCode(String code);

  /**
   * 获取组织的上级组织
   * @param childId
   * @return
   */
  OrganizationVo findByChild(String childId);

  /**
   * 根据用户ID查询主组织机构
   * @param userId
   * @return
   */
  OrganizationVo findMainOrgByUserId(String userId);

}
