package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.UserVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.bizunited.platform.rbac.server.vo.PositionVo;

import java.util.List;
import java.util.Set;

/**
 * PositionService
 * 
 * @description:
 * @author: yanwe
 * @date: 17/Jan/2019 14:55
 */
public interface PositionService {
  /**
   * 按条件分页查询
   *
   * @param code
   * @param name
   * @param tstatus
   * @param pageable
   * @return
   */
  Page<PositionVo> findByConditions(String code, String name, Integer tstatus, Pageable pageable);
  /**
   * 添加
   *
   * @param PositionVo
   * @return
   */
  PositionVo create(PositionVo positionEntity);
  /**
   * 更新
   *
   * @param PositionVo
   * @return
   */
  PositionVo update(PositionVo positionEntity);
  /**
   * 改变状态
   *
   * @param positionId
   * @return
   */
  PositionVo updateStatus(String positionId);
  /**
   * 绑定某一组织机构与某一岗位关系
   *
   * @param orgId
   * @param positionId
   */
  void bindOrgAndPosition(String orgId, String positionId);

  /**
   * 解绑某一组织机构与某一岗位关系
   *
   * @param orgId
   * @param positionId
   */
  void unbindOrgAndPosition(String orgId, String positionId);
  /**
   * 绑定某一角色与某一岗位关系
   *
   * @param roleId
   * @param positionId
   */
  void bindRoleAndPosition(String roleId, String positionId);
  /**
   * 绑定多个角色与某一岗位
   *
   * @param roleIds
   * @param positionId
   */
  void bindRolesAndPosition(List<String> roleIds, String positionId);
  /**
   * 解绑某一角色与某一岗位关系
   *
   * @param roleId
   * @param positionId
   */
  void unbindRoleAndPosition(String roleId, String positionId);
  /**
   * 解绑多个角色与某一岗位
   *
   * @param roleIds
   * @param positionId
   */
  void unbindRolesAndPosition(List<String> roleIds, String positionId);
  /**
   * 绑定多个用户与某一岗位关系
   *
   * @param userIds
   * @param positionId
   */
  void bindUsersAndPosition(List<String> userIds, String positionId);
  /**
   * 解绑多个用户与某一岗位关系
   *
   * @param userIds
   * @param positionId
   */
  void unbindUsersAndPosition(List<String> userIds, String positionId);
  /**
   * 根据ID查询岗位的详细信息，包括相关组织、角色、用户等
   *
   * @param id
   * @return
   */
  PositionVo findDetailsById(String id);
  /**
   * 预制控件查询，暂时查询当前实例创建用户岗位信息
   * @param instanceId
   * @return
   */
  List<PositionVo> findByUserId(String userId);

  /**
   * 查询多个岗位信息
   * @param ids
   * @return
   */
  Set<PositionVo> findByIds(List<String> ids);

  /**
   * 根据岗位编码查询
   * @param code
   * @return
   */
  PositionVo findByCode(String code);

  /**
   * 切换岗位
   * @param positionId
   */
  UserVo changePosition(String positionId, String userId);

  /**
   * 查询Redis中主岗位，如果redis中不存在，则默认主岗位为数据库查询的第一条数据，并且将该数据存入redis中
   * @param userId
   * @return
   */
  PositionVo findMainPositionByUserId(String userId);

  /**
   * 根据条件查询所有岗位
   * @param position
   * @return
   */
  List<PositionVo> findAllByConditions(PositionVo position);

}
