package com.bizunited.platform.rbac.server.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation.RelationType;
import com.bizunited.platform.saturn.engine.annotation.SaturnDefaultController;
import com.bizunited.platform.saturn.engine.annotation.SaturnDefaultController.Type;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;

import java.util.Date;
import java.util.Set;

/**
 * 组织机构信息的Vo模型支持
 * @author yinwenjie
 */
@SaturnEntity(name="OrganizationVo" , description="组织机构")
public class OrganizationVo extends AbstractBelongUser {
  /**
   * 抽象VO层模型的编号信息.
   */
  @SaturnColumn(pkColumn=true, insertable=true, updatable=false, nullable=true, description="主键")
  private String id;
  @SaturnColumn(description="组织机构的唯一编号", length=128, nullable=false,unique = true)
  private String code;
  @SaturnColumn(description = "组织机构名称", length = 64, nullable = false)
  private String orgName;
  @SaturnColumn(description = "组织机构类型", nullable = false)
  private String type;
  @SaturnColumn(description = "组织机构描述", nullable = false, length = 512)
  private String description = "";
  @SaturnColumn(description = "组织机构排序", nullable = false)
  private Integer sortIndex = 100;
  @SaturnColumn(description = "创建时间", nullable = false)
  private Date createTime = new Date();
  @SaturnColumn(description = "组织机构绑定的用户信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany, master=true, mappedBy="orgs")
  private Set<UserVo> users;
  @SaturnColumn(description = "组织机构绑定的角色信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany, master=true, mappedBy="orgs")
  private Set<RoleVo> roles;
  @SaturnColumn(description = "组织机构绑定的岗位信息")
  @SaturnColumnRelation(type=RelationType.OneToMany, mappedBy="organization")
  private Set<PositionVo> positions;

  @SaturnColumn(description = "子级组织")
  @SaturnColumnRelation(type=RelationType.OneToMany, master=true, mappedBy="orgs")
  private Set<OrganizationVo> child;

  @SaturnColumn(description = "父级组织")
  @SaturnColumnRelation(type=RelationType.ManyToOne)
  OrganizationVo parent;
  @SaturnColumn(description = "组织机构状态", nullable = false)
  @SaturnDefaultController(defaultType=Type.SELECT, defaultKeys="正常,不正常", defaultValues="1,0")
  private Integer tstatus;
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getOrgName() {
    return orgName;
  }
  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }
  public Integer getSortIndex() {
    return sortIndex;
  }
  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
  public Set<PositionVo> getPositions() {
    return positions;
  }
  public void setPositions(Set<PositionVo> positions) {
    this.positions = positions;
  }
  public OrganizationVo getParent() {
    return parent;
  }
  public void setParent(OrganizationVo parent) {
    this.parent = parent;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Set<OrganizationVo> getChild() {
    return child;
  }
  public void setChild(Set<OrganizationVo> child) {
    this.child = child;
  }

  @Override
  public Date getCreateTime() {
    return createTime;
  }

  @Override
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  @Override
  public Set<UserVo> getUsers() {
    return users;
  }

  @Override
  public void setUsers(Set<UserVo> users) {
    this.users = users;
  }

  @Override
  public Set<RoleVo> getRoles() {
    return roles;
  }

  @Override
  public void setRoles(Set<RoleVo> roles) {
    this.roles = roles;
  }
}
