package com.bizunited.platform.rbac.server.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation.RelationType;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;

import java.util.Date;
import java.util.Set;

/**
 * 博智中间件平台用户角色信息描述
 * @author yinwenjie
 * @version V1.1
 */
@SaturnEntity(description="角色信息" , name="RoleVo")
public class RoleVo {
  /**
   * 抽象VO层模型的编号信息.
   */
  @SaturnColumn(pkColumn=true , insertable=true , updatable=false , nullable=true , description="主键")
  private String id;
  /** 角色的业务编号. **/
  @SaturnColumn(description="角色的业务编号", length = 64, nullable = false, unique = true)
  private String roleCode = "";
  /** 角色名称(只能是英文，且保存时必须是大写). **/
  @SaturnColumn(description="角色名称", length = 64, nullable = false, unique = true)
  private String roleName = "";
  /** 
   * 角色类型编号 
   * T001：业务角色
   * T002：管理角色
   */
  @SaturnColumn(description="角色类型编号" , length = 64, nullable = false)
  private String roleType = "";
  /** 状态 1正常, 0禁用(枚举). **/
  @SaturnColumn(description="角色状态", nullable = false)
  private Integer tstatus = 1;
  /** 创建时间. **/
  @SaturnColumn(description="创建时间", nullable = false)
  private Date createDate = new Date();
  /**
   * 是否系统角色，如果是系统角色就不允许操作者删除
   */
  @SaturnColumn(description="是否系统角色", nullable = false)
  private Boolean isDeny = false;
  /**
   * 角色后默认页面跳转路径
   */
  @SaturnColumn(description = "角色默认页面跳转路径" ,length = 512)
  private String defaultUrl;
  /** 备注.角色信息说明，备注信息不用填写，但是至少需要在写操作时传入空字符串 **/
  @SaturnColumn(description="角色备注", length = 64, nullable = true)
  private String comment = "";
  /**
   * 这个角色已经绑定的用户信息
   */
  @SaturnColumn(description="角色已经绑定的用户信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<UserVo> users;

  /** 角色和功能菜单的对应关系. **/
  @SaturnColumn(description="角色和功能菜单的对应关系")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<CompetenceVo> competences;

  /** 角色和按钮的对应关系. **/
  @SaturnColumn(description="角色和按钮的对应关系")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<ButtonVo> buttons;

  @SaturnColumn(description="角色的父级")
  @SaturnColumnRelation(type=RelationType.ManyToOne)
  private RoleVo parent;
  @SaturnColumnRelation(type=RelationType.OneToMany)
  @SaturnColumn(description="角色的子级")
  private Set<RoleVo> children;
  /**来源**/
  private String source;

  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public RoleVo getParent() {
    return parent;
  }

  public void setParent(RoleVo parent) {
    this.parent = parent;
  }

  public Set<RoleVo> getChildren() {
    return children;
  }

  public void setChildren(Set<RoleVo> children) {
    this.children = children;
  }

  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getRoleCode() {
    return roleCode;
  }
  public void setRoleCode(String roleCode) {
    this.roleCode = roleCode;
  }
  public String getRoleName() {
    return roleName;
  }
  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }
  public String getRoleType() {
    return roleType;
  }
  public void setRoleType(String roleType) {
    this.roleType = roleType;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Date getCreateDate() {
    return createDate;
  }
  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }
  public Boolean getIsDeny() {
    return isDeny;
  }
  public void setIsDeny(Boolean isDeny) {
    this.isDeny = isDeny;
  }
  public String getDefaultUrl() {
    return defaultUrl;
  }
  public void setDefaultUrl(String defaultUrl) {
    this.defaultUrl = defaultUrl;
  }
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }
  public Set<UserVo> getUsers() {
    return users;
  }
  public void setUsers(Set<UserVo> users) {
    this.users = users;
  }

  public Set<ButtonVo> getButtons() {
    return buttons;
  }

  public void setButtons(Set<ButtonVo> buttons) {
    this.buttons = buttons;
  }

  public Boolean getDeny() {
    return isDeny;
  }

  public void setDeny(Boolean deny) {
    isDeny = deny;
  }
  public Set<CompetenceVo> getCompetences() {
    return competences;
  }
  public void setCompetences(Set<CompetenceVo> competences) {
    this.competences = competences;
  }
}