package com.bizunited.platform.rbac.server.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * redis的封装配置信息在这里，为什么要进行配置封装：<p>
 * 1、是因为redis的连接模式有多种，需要将这多种配置情况对上层使用者透明化<br>
 * 2、是因为在特殊场景下，除了使用redisson以外，还会同时使用jredis。
 * @author yinwenjie
 */
@ConfigurationProperties(prefix = "redis")
public class RedisCustomProperties {
  /**
   * redis的连接模式</br>
   * 一共三种 单点模式(single)，集群模式(cluster)，哨兵模式(sentinel)
   */
  private String model;
  /**
   * redis的一个或者多个连接地址
   */
  private String[] address;
  /**
   * 数据库
   */
  private int database = 0;
  /**
   * 命令反馈超时时间（单位毫秒）
   */
  private int timeout = 3000;
  /**
   * 重试尝试次数
   */
  private int retryAttempts = 10;
  /**
   * 重试连接间隔时间
   */
  private int retryInterval = 1500;
  /**
   * 心跳间隔
   */
  private int pingConnectionInterval = 1000 * 60 * 2;
  /**
   * 各种环境里共用的连接数大小，包括master、salve、订阅和发布等环境
   */
  private int connectionPoolSize = 64;
  /**
   * 各种环境里共用的最小空闲连接数大小，包括master、salve、订阅和发布等环境
   */
  private int connectionMinimumIdleSize = 32;
  /**
   * 可能存在的redis登录密码
   */
  private String password;

  public String getModel() {
    return model;
  }
  public void setModel(String model) {
    this.model = model;
  }
  public String[] getAddress() {
    return address;
  }
  public void setAddress(String[] address) {
    this.address = address;
  }
  public int getTimeout() {
    return timeout;
  }
  public void setTimeout(int timeout) {
    this.timeout = timeout;
  }
  public int getConnectionPoolSize() {
    return connectionPoolSize;
  }
  public void setConnectionPoolSize(int connectionPoolSize) {
    this.connectionPoolSize = connectionPoolSize;
  }
  public int getConnectionMinimumIdleSize() {
    return connectionMinimumIdleSize;
  }
  public void setConnectionMinimumIdleSize(int connectionMinimumIdleSize) {
    this.connectionMinimumIdleSize = connectionMinimumIdleSize;
  }
  public String getPassword() {
    return password;
  }
  public void setPassword(String password) {
    this.password = password;
  }

  public int getRetryAttempts() {
    return retryAttempts;
  }

  public void setRetryAttempts(int retryAttempts) {
    this.retryAttempts = retryAttempts;
  }

  public int getRetryInterval() {
    return retryInterval;
  }

  public void setRetryInterval(int retryInterval) {
    this.retryInterval = retryInterval;
  }
  public int getPingConnectionInterval() {
    return pingConnectionInterval;
  }
  public void setPingConnectionInterval(int pingConnectionInterval) {
    this.pingConnectionInterval = pingConnectionInterval;
  }

  public int getDatabase() {
    return database;
  }

  public void setDatabase(int database) {
    this.database = database;
  }
}