package com.bizunited.platform.rbac.server.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation.RelationType;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;

@SaturnEntity(description="用户组信息" , name="UserGroupVo")
public class UserGroupVo  extends AbstractBelongUser implements Serializable {
  private static final long serialVersionUID = -5275703207054936579L;
  /**
   * 抽象VO层模型的编号信息.
   */
  @SaturnColumn(pkColumn=true , insertable=true , updatable=false , nullable=true , description="主键")
  private String id;
  /**
   * 用户组名称
   */
  @SaturnColumn(description="用户组名称" , length = 64, nullable = false,unique = true)
  private String groupName;
  /**
   * 用户组描述
   */
  @SaturnColumn(description = "用户组描述" ,nullable = false,length = 512)
  private String groupDescription;
  /**
   * 用户组状态(0:禁用,1:启用)
   */
  @SaturnColumn(description = "用户组状态" ,nullable = false)
  private Integer tstatus;
  /**
   * 创建时间
   */
  @SaturnColumn(description="创建时间", nullable = false)
  private Date createTime=new Date();
  /**
   * 用户组用户关联
   */
  @SaturnColumn(description="用户组绑定的用户信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<UserVo> users;
  /**
   * 用户组角色关联
   */
  @SaturnColumn(description="用户组绑定的角色信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<RoleVo> roles;
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getGroupName() {
    return groupName;
  }
  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }
  public String getGroupDescription() {
    return groupDescription;
  }
  public void setGroupDescription(String groupDescription) {
    this.groupDescription = groupDescription;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
}
