package com.bizunited.platform.rbac.server.vo;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * rbac环境设置
 * @Author: Paul Chan
 * @Date: 2019-11-25 15:28
 */
@ApiModel(value = "RbacSettingVo", description = "rbac环境设置")
public class RbacSettingVo extends UuidEntity {
  private static final long serialVersionUID = 2662751725141467991L;


  /**
   * 用户和角色的关系 0：多对多，1：多对一，2：一对多，3：一对一
   */
  @ApiModelProperty("用户和角色的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  @SaturnColumn(description = "用户和角色的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  private Integer userRoleRelation;

  /**
   * 角色和分组的关系 0：多对多，1：多对一，2：一对多，3：一对一
   */
  @ApiModelProperty("角色和分组的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  @SaturnColumn(description = "角色和分组的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  private Integer roleGroupRelation;

  /**
   * 角色和组织机构的关系 0：多对多，1：多对一，2：一对多，3：一对一
   */
  @ApiModelProperty("角色和组织机构的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  @SaturnColumn(description = "角色和组织机构的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  private Integer roleOrgRelation;

  /**
   * 角色和岗位的关系 0：多对多，1：多对一，2：一对多，3：一对一
   */
  @ApiModelProperty("角色和岗位的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  @SaturnColumn(description = "角色和岗位的关系 0：多对多，1：多对一，2：一对多，3：一对一")
  private Integer rolePositionRelation;


  public Integer getUserRoleRelation() {
    return userRoleRelation;
  }

  public void setUserRoleRelation(Integer userRoleRelation) {
    this.userRoleRelation = userRoleRelation;
  }

  public Integer getRoleGroupRelation() {
    return roleGroupRelation;
  }

  public void setRoleGroupRelation(Integer roleGroupRelation) {
    this.roleGroupRelation = roleGroupRelation;
  }

  public Integer getRoleOrgRelation() {
    return roleOrgRelation;
  }

  public void setRoleOrgRelation(Integer roleOrgRelation) {
    this.roleOrgRelation = roleOrgRelation;
  }

  public Integer getRolePositionRelation() {
    return rolePositionRelation;
  }

  public void setRolePositionRelation(Integer rolePositionRelation) {
    this.rolePositionRelation = rolePositionRelation;
  }

}
