package com.bizunited.platform.rbac.server.service;

/**
 * @author: weikangning
 * @Date: 2020/8/16 21:26
 * @Description: 角色和职位级别映射信息服务
 */
public interface RolePositionLevelMappingService {
  /**
   * 将指定职位级别绑定一个或多个角色
   *
   * @param positionLevelCode
   * @param roleIds
   */
  void bindPositionLevelRoles(String positionLevelCode, String[] roleIds);

  /**
   * 将指定职位级别重新绑定一个或多个角色
   *
   * @param positionLevelCode
   * @param roleIds
   */
  void rebindPositionLevelRoles(String positionLevelCode, String[] roleIds);

  /**
   * 将指定职位级别解除一个或多个角色的绑定
   *
   * @param positionCode
   * @param roleIds
   */
  void unbindPositionLevelRoles(String positionCode, String[] roleIds);
}
