package com.bizunited.platform.rbac.server.service;

import java.util.Set;

import com.bizunited.platform.user.common.vo.PositionVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * 角色和岗位映射信息服务
 * @author yinwenjie
 */
public interface RolePositionMappingService {
  /**
   * 将指定角色绑定一个或多个岗位
   * @param roleId
   * @param positionCodes
   */
  void bindPositions(String roleId, String[] positionCodes);
  /**
   * 解除指定角色和一个或多个岗位的绑定关系
   * @param roleId
   * @param positionCodes
   */
  void unbindPositions(String roleId, String[] positionCodes);

  /**
   * 解除指定角色和所有关联岗位的绑定关系
   * @param roleId
   */
  void unbindAllByRoleId(String roleId);

  /**
   * 将指定岗位重新绑定一个或多个角色
   * @param roleId
   * @param positionCodes
   */
  void rebindPositions(String roleId, String[] positionCodes);
  /**
   * 将指定岗位绑定一个或多个角色
   * @param positionCode
   * @param roleIds
   */
  void bindPositionRoles(String positionCode, String[] roleIds);
  /**
   * 将指定岗位解除一个或多个角色的绑定
   * @param positionCode
   * @param roleIds
   */
  void unbindPositionRoles(String positionCode, String[] roleIds);
  /**
   * 将指定岗位重新绑定一个或多个角色
   * @param positionCode
   * @param roleIds
   */
  void rebindPositionRoles(String positionCode, String[] roleIds);
  /**
   * 根据角色ID查询直接关联的岗位
   * @param roleId
   * @return
   */
  Set<PositionVo> findByRoleId(String roleId);

  /**
   * 根据角色ID查询直接关联的岗位
   * @param roleId
   * @return
   */
  Page<PositionVo> findPageByRoleId(String roleId, String name, String userName, Pageable pageable);

  /**
   * 根据角色ID查询没有关联该角色的岗位
   * @param roleId
   * @param name
   * @param userName
   * @param pageable
   * @return
   */
  Page<PositionVo> findNotBindRole(String roleId,String name, String userName, Pageable pageable);

  /**
   * 分页查询没有绑定任何角色的职位
   * @return
   * @param name
   * @param userName
   * @param pageable
   */
  Page<PositionVo> findNotBindAnyRole(String name, String userName, Pageable pageable);

  /**
   * 根据角色主键、指定新的角色主键、职位编码列表，替换指定职位的绑定角色
   * @param roleId 角色主键
   * @param rebindRoleId 新的角色主键
   * @param positionCodes 职位编码列表
   */
  void rebindPositionsById(String roleId,String rebindRoleId ,String[] positionCodes);
}