/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.user.common.service.position.PositionLevelEventListener;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="PositionLevelEventListenerImpl")
public class RolePositionLevelBindListener
implements PositionLevelEventListener {
    @Autowired
    private RolePositionLevelMappingService rolePositionLevelMappingService;

    @Transactional
    public void onPositionLevelCreated(PositionLevelVo positionLevel) {
        if (positionLevel == null) {
            return;
        }
        List roleCodes = (List)ObjectUtils.defaultIfNull((Object)positionLevel.getRoleCodes(), (Object)Lists.newArrayList());
        String[] roleCodesArray = roleCodes.toArray(new String[roleCodes.size()]);
        if (!CollectionUtils.isEmpty((Collection)roleCodes)) {
            this.rolePositionLevelMappingService.bindPositionLevelRoles(positionLevel.getCode(), roleCodesArray);
        }
    }

    @Transactional
    public void onPositionLevelUpdated(PositionLevelVo positionLevel) {
        if (positionLevel == null) {
            return;
        }
        List roleCodes = (List)ObjectUtils.defaultIfNull((Object)positionLevel.getRoleCodes(), (Object)Lists.newArrayList());
        String[] roleCodesArray = roleCodes.toArray(new String[roleCodes.size()]);
        if (!CollectionUtils.isEmpty((Collection)roleCodes)) {
            this.rolePositionLevelMappingService.rebindPositionLevelRoles(positionLevel.getCode(), roleCodesArray);
        }
    }

    public void onPositionLevelDeleted(PositionLevelVo positionLevel) {
        if (positionLevel == null) {
            return;
        }
        List roleCodes = (List)ObjectUtils.defaultIfNull((Object)positionLevel.getRoleCodes(), (Object)Lists.newArrayList());
        String[] roleCodesArray = roleCodes.toArray(new String[roleCodes.size()]);
        if (!CollectionUtils.isEmpty((Collection)roleCodes)) {
            this.rolePositionLevelMappingService.unbindPositionLevelRoles(positionLevel.getCode(), roleCodesArray);
        }
    }
}

