package com.bizunited.platform.rbac.server.service;

import java.util.Set;

import com.bizunited.platform.user.common.vo.PositionVo;

/**
 * 角色和岗位映射信息服务
 * @author yinwenjie
 */
public interface RolePositionMappingService {
  /**
   * 将指定角色绑定一个或多个岗位
   * @param roleId
   * @param positionCodes
   */
  void bindPositions(String roleId, String[] positionCodes);
  /**
   * 解除指定角色和一个或多个岗位的绑定关系
   * @param roleId
   * @param positionCodes
   */
  void unbindPositions(String roleId, String[] positionCodes);
  /**
   * 将指定岗位重新绑定一个或多个角色
   * @param roleId
   * @param positionCodes
   */
  void rebindPositions(String roleId, String[] positionCodes);
  /**
   * 将指定岗位绑定一个或多个角色
   * @param positionCode
   * @param roleIds
   */
  void bindPositionRoles(String positionCode, String[] roleIds);
  /**
   * 将指定岗位解除一个或多个角色的绑定
   * @param positionCode
   * @param roleIds
   */
  void unbindPositionRoles(String positionCode, String[] roleIds);
  /**
   * 将指定岗位重新绑定一个或多个角色
   * @param positionCode
   * @param roleIds
   */
  void rebindPositionRoles(String positionCode, String[] roleIds);
  /**
   * 根据角色ID查询直接关联的岗位
   * @param roleId
   * @return
   */
  Set<PositionVo> findByRoleId(String roleId);
}