package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.RoleVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

public interface RoleService {
  /**
   * 该方法用于添加一个角色信息，这个角色信息的名字必须是唯一的
   * @param role 新的角色信息
   * @return
   */
  RoleVo create(RoleVo role);
  /**
   * 修改一个指定的角色信息，注意配置在roles.deleteDeny属性的信息不能进行修改操作<br>
   * 且指定的一个角色只能修改角色的comment信息
   * 
   * @param role 指定的修改信息
   * @return
   */
  RoleVo update(RoleVo role);
  /**
   * 批量重新启用某一个指定的角色信息
   * 
   * @param roleIds
   * @return
   */
  void enable(String[] roleIds);
  /**
   * 批量禁用某一个指定的角色信息（相当于删除）<br>
   * 只是系统中不能真正的删除某一个角色，只能是将这个角色作废掉或者恢复正常状态
   * 
   * @param roleIds
   * @return
   */
  void disable(String[] roleIds);
  /**
   * 查询指定的角色信息，按照角色的数据层编号查询
   * @param roleId 角色编号
   * @return
   */
  RoleVo findById(String roleId);
  /**
   * 查询符合角色状态的信息
   * 
   * @param useStatus 目前只有两种状态的枚举，一种是正常另外一种是作废
   * @return
   */
  List<RoleVo> findByStatus(Integer useStatus);
  /**
   * 查询指定的用户所绑定的角色信息(只包括角色基本信息)，
   * 这些角色信息包括了用户自己绑定的、用户可能所在用户组绑定的、用户所在组织机构绑定的，甚至第三方系统的，等等
   * 因为有主副岗位之分，在查询用户的角色用于权限验证时，岗位绑定的角色只会查询主岗位绑定的角色，用户角色维护时，则返回用户所有岗位绑定的角色
   * @param type 查询类型，不传默认为0，0：只是查询用户的角色用于权限验证，1：查询用户的角色用于角色维护
   * @return
   */
  List<RoleVo> findAllByUserId(String userId, Integer type);
  /**
   * 查询指定的功能描述所绑定的角色信息(只包括角色基本信息)
   * @param competenceId 功能描述信息
   * @return
   */
  List<RoleVo> findByCompetenceId(String competenceId);
  /**
   * 查询多个角色信息
   * @param ids
   * @return
   */
  Set<RoleVo> findByIds(List<String> ids);
  /**
   * 查询角色树状关系
   * @return
   */
  Set<RoleVo> findRoleTree();

  /**
   * 根据角色名称，或则角色编码，或则角色编码查询角色信息 （角色名称支持模糊查询）
   * @param conditions
   * @return
   */
  List<RoleVo> findByConditions(Map<String, Object> conditions);
  /**
   * 根据code查询角色
   * @param code
   * @return
   */
  RoleVo findByCode(String code);
  /**
   * 根据用户ID查询用户直接关联的角色
   * @param userId
   * @return
   */
  Set<RoleVo> findByUserId(String userId);
  /**
   * 根据用户账户查询用户直接关联的角色
   * @param account 用户账户信息
   * @return
   */
  Set<RoleVo> findByUserAccount(String account);
  /**
   * 根据角色名称查询角色信息
   * @param roleNames
   * @return
   */
  Set<RoleVo> findByRoleNames(Set<String> roleNames);
  /**
   * 根据组织机构编码查询绑定的角色
   * @param orgCode
   * @return
   */
  List<RoleVo> findByOrgCode(String orgCode);
  /**
   * 根据岗位编号查询直接关联的角色
   * @param positionCode
   * @return
   */
  Set<RoleVo> findByPositionCode(String positionCode);
  /**
   * 根据用户组编码查询绑定的角色
   * @param userGroupCode
   * @return
   */
  List<RoleVo> findByGroupCode(String userGroupCode);
  /**
   * 查询目前系统中所有的角色信息，无论这些角色信息是否可用（但是只包括角色的基本信息）
   * @return
   */
  List<RoleVo> findAll();

  /**
   * 根据角色编码删除（只能删除无绑定关系的角色）
   * @param roleCodes
   */
  void deleteByCodes(String[] roleCodes);

  /**
   * 根据角色编码查询角色信息
   * @param roleCodes
   * @return
   */
  Set<RoleVo> findByRoleCodes(Set<String> roleCodes);
}