package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.user.common.service.position.PositionLevelEventListener;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.google.common.collect.Lists;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 职级绑定角色监听器
 * @Author : chengzhongxiang
 * @Date: 2020-09-28 14:09
 */
@Component("PositionLevelEventListenerImpl")
public class RolePositionLevelBindListener implements PositionLevelEventListener {

  @Autowired
  private RolePositionLevelMappingService rolePositionLevelMappingService;

  /**
   * 在职级创建时触发监听器，绑定角色
   * @param positionLevel
   */
  @Override
  @Transactional
  public void onPositionLevelCreated(PositionLevelVo positionLevel) {
    if(positionLevel == null) {
      return;
    }
    List<String> roleCodes = ObjectUtils.defaultIfNull(positionLevel.getRoleCodes(), Lists.newArrayList());
    String[] roleCodesArray = roleCodes.toArray(new String[roleCodes.size()]);
    if(!CollectionUtils.isEmpty(roleCodes)){
      rolePositionLevelMappingService.bindPositionLevelRoles(positionLevel.getCode(), roleCodesArray);
    }
  }

  /**
   * 在职级更新时触发监听器，更新绑定角色
   * @param positionLevel
   */
  @Override
  @Transactional
  public void onPositionLevelUpdated(PositionLevelVo positionLevel) {
    if(positionLevel == null) {
      return;
    }
    List<String> roleCodes = ObjectUtils.defaultIfNull(positionLevel.getRoleCodes(), Lists.newArrayList());
    String[] roleCodesArray = roleCodes.toArray(new String[roleCodes.size()]);
    if(!CollectionUtils.isEmpty(roleCodes)){
      rolePositionLevelMappingService.rebindPositionLevelRoles(positionLevel.getCode(), roleCodesArray);
    }
  }

  @Override
  public void onPositionLevelDeleted(PositionLevelVo positionLevel) {
    if(positionLevel == null) {
      return;
    }
    List<String> roleCodes = ObjectUtils.defaultIfNull(positionLevel.getRoleCodes(), Lists.newArrayList());
    String[] roleCodesArray = roleCodes.toArray(new String[roleCodes.size()]);
    if(!CollectionUtils.isEmpty(roleCodes)) {
      rolePositionLevelMappingService.unbindPositionLevelRoles(positionLevel.getCode(), roleCodesArray);
    }
  }
}
