package com.bizunited.platform.rbac.server.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;

import java.util.Set;

/**
 * 页面按钮数据持久化描述
 * @Author: Paul Chan
 * @Date: 2020-01-10 15:16
 */
@SaturnEntity(description="页面按钮" , name="ButtonVo")
public class ButtonVo {

  /**
   * 关联的菜单
   */
  @SaturnColumn(description = "关联的菜单")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.ManyToOne)
  private CompetenceVo competence;

  /**
   * 关联的角色
   */
  @SaturnColumn(description = "关联的角色")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.ManyToMany, mappedBy = "buttons")
  private Set<RoleVo> roles;

  /**
   * 主键
   */
  @SaturnColumn(pkColumn=true , insertable=true , updatable=false , nullable=true , description="主键")
  private String id;

  /** 按钮编码 **/
  @SaturnColumn(description="按钮编码", nullable = false, unique = true)
  private String code;

  /**
   * 按钮名称
   */
  @SaturnColumn(description="按钮名称", nullable = false)
  private String name;

  /**
   * 按钮说明
   */
  @SaturnColumn(description="按钮说明")
  private String buttonDesc;

  /**
   * 是否是系统按钮
   */
  @SaturnColumn(description="是否是系统按钮")
  private Boolean system;

  /**
   * 关联的接口
   */
  @SaturnColumn(description = "关联的接口")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.ManyToMany, master = true)
  private Set<CompetenceVo> competences;

  /**
   * 项目名称
   */
  @SaturnColumn(description = "项目名称")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public CompetenceVo getCompetence() {
    return competence;
  }

  public void setCompetence(CompetenceVo competence) {
    this.competence = competence;
  }

  public Set<RoleVo> getRoles() {
    return roles;
  }

  public void setRoles(Set<RoleVo> roles) {
    this.roles = roles;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getButtonDesc() {
    return buttonDesc;
  }

  public void setButtonDesc(String buttonDesc) {
    this.buttonDesc = buttonDesc;
  }

  public Boolean getSystem() {
    return system;
  }

  public void setSystem(Boolean system) {
    this.system = system;
  }

  public Set<CompetenceVo> getCompetences() {
    return competences;
  }

  public void setCompetences(Set<CompetenceVo> competences) {
    this.competences = competences;
  }
}
