package com.bizunited.platform.rbac.server.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation.RelationType;
import com.bizunited.platform.user.common.vo.UserVo;

import java.util.Date;
import java.util.Set;

/**
 * 由于整个vo定义中，有多处vo模型都定义了创建时间、关联的用户、关联的角色信息</br>
 * 所以本类把这些公共信息抽取出来，以避免重复代码
 * @author yinwenjie
 */
public abstract class AbstractBelongUser {
  /**
   * 创建时间
   */
  @SaturnColumn(description="创建时间", nullable = false)
  private Date createTime=new Date();
  /**
   * 关联的用户信息
   */
  @SaturnColumn(description="用户组绑定的用户信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<UserVo> users;
  /**
   * 关联的角色信息
   */
  @SaturnColumn(description="用户组绑定的角色信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<RoleVo> roles;
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Set<UserVo> getUsers() {
    return users;
  }
  public void setUsers(Set<UserVo> users) {
    this.users = users;
  }
  public Set<RoleVo> getRoles() {
    return roles;
  }
  public void setRoles(Set<RoleVo> roles) {
    this.roles = roles;
  }
}
