package com.bizunited.platform.rbac.server.service;


import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.rbac.server.vo.RoleExtendVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * RoleEXtendVo业务模型的服务层接口定义
 * @author saturn
 */
public interface RoleExtendVoService {
  /**
   * 创建一个新的RoleEXtendVo模型对象
   */
   RoleExtendVo create(RoleExtendVo roleEXtendVo);

  /**
   * create方法的具体业务实现
   * @param roleEXtendVo
   * @return
   */
   RoleExtendVo createForm(RoleExtendVo roleEXtendVo);
  /**
   * 更新一个已有的RoleEXtendVo模型对象，其主键属性必须有值(1.1.4-release版本调整)。
   */
   RoleExtendVo update(RoleExtendVo roleEXtendVo);

  /**
   * update方法的具体实现
   * @param roleEXtendVo
   * @return
   */
   RoleExtendVo updateForm(RoleExtendVo roleEXtendVo);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
   RoleExtendVo findDetailsById(String id);

  /**
   * 带分页的条件查询，根据名称模糊、编码模糊、状态分页查询角色
   * @param roleName
   * @param roleCode
   * @param tstatus
   * @param pageable
   * @return
   */
  Page<JSONObject> queryPage(String roleName, String roleCode, Integer tstatus, Pageable pageable);
  /**
   * 按照RoleEXtendVo的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
   RoleExtendVo findById(String id);

  /**
   * 根据角色编码删除角色拓展，同时解绑全部菜单、按钮
   * @param roleCode 角色编码
   */
   void deleteByRoleCode(String roleCode);

  /**
   * 根据角色编码批量删除角色拓展，同时解绑全部菜单、按钮
   * @param roleCodes 角色编码
   */
   void deleteByCodes(String[] roleCodes);
}