package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.rbac.server.service.RolePositionMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.position.PositionLevelEventListener;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;

/**
 * @ClassName : RolePositionLevelBindListener
 * @Description : 职级绑定角色监听器
 * @Author : chengzhongxiang
 * @Date: 2020-09-28 14:09
 */
@Component("PositionLevelEventListenerImpl")
public class RolePositionLevelBindListener implements PositionLevelEventListener {

  @Autowired
  private RoleService roleService;
  @Autowired
  private RolePositionLevelMappingService rolePositionLevelMappingService;
  /**
   * 在职级创建时触发监听器，绑定角色
   * @param positionLevelCode 职级编号
   * @param roleIds           角色id数组
   */
  @Override
  @Transactional
  public void onPositionLevelCreate(String positionLevelCode, String[] roleIds) {
    Validate.notEmpty(roleIds,"角色主键不能为空");
    ArrayList<String> roleIdList = new ArrayList<>(Arrays.asList(roleIds));
    Set<RoleVo> roleVos = this.roleService.findByIds(roleIdList);
    Validate.notEmpty(roleVos,"没有找到指定的角色");
    Validate.notBlank(positionLevelCode,"指定的职级编码不能为空");
    this.rolePositionLevelMappingService.bindPositionLevelRoles(positionLevelCode,roleIds);
  }

  /**
   * 在职级更新时触发监听器，更新绑定角色
   * @param positionLevelCode 职级编号
   * @param roleIds           角色id数组
   */
  @Override
  @Transactional
  public void onPositionLevelUpdate(String positionLevelCode, String[] roleIds) {
    Validate.notEmpty(roleIds,"角色主键不能为空");
    ArrayList<String> roleIdList = new ArrayList<>(Arrays.asList(roleIds));
    Set<RoleVo> roleVos = this.roleService.findByIds(roleIdList);
    Validate.notEmpty(roleVos,"没有找到指定的角色");
    Validate.notBlank(positionLevelCode,"指定的职级编码不能为空");
    this.rolePositionLevelMappingService.rebindPositionLevelRoles(positionLevelCode,roleIds);

  }
}
