package com.bizunited.platform.rbac.server.service;

import java.util.List;

import com.bizunited.platform.user.common.vo.OrganizationVo;

/**
 * 角色和组织机构映射信息服务
 * @author yinwenjie
 */
public interface RoleOrgMappingService {
  /**
   * 将指定角色绑定一个或多个组织机构
   * @param roleId
   * @param orgCodes
   */
  void bindOrgs(String roleId, String[] orgCodes);

  /**
   * 将指定角色重新绑定一个或多个组织机构
   * @param roleId
   * @param orgCodes
   */
  void rebindOrgs(String roleId, String[] orgCodes);

  /**
   * 解除指定角色和指定组织机构的绑定关系
   * @param roleId
   * @param orgCodes
   */
  void unbindOrgs(String roleId, String[] orgCodes);
  /**
   * 将指定组织机构绑定一个或多个角色
   * @param orgCode
   * @param roleIds
   */
  void bindOrgRoles(String orgCode, String[] roleIds);

  /**
   * 解除指定组织机构和角色的绑定关系
   * @param orgCode
   * @param roleIds
   */
  void unbindOrgRoles(String orgCode, String[] roleIds);
  /**
   * 将指定组织机构重新绑定角色
   * @param orgCode
   * @param roleIds
   */
  void rebindOrgRoles(String orgCode, String[] roleIds);
  /**
   * findOrgsByRoleId
   * @param roleId
   * @return
   */
  List<OrganizationVo> findByRoleId(String roleId);

}