package com.bizunited.platform.rbac.server.service;

import java.util.List;

import com.bizunited.platform.user.common.vo.UserGroupVo;

/**
 * 角色和用户组映射信息服务
 * @author yinwenjie
 */
public interface RoleUserGroupMappingService {
  /**
   * 用户组与角色绑定(可以绑定多个角色id，不过只要有一个角色id绑定错误，则整个绑定过程失败)
   * @param userGroupCodes 用户组编号
   * @param roleId  角色id
   */
  void bindUserGroups(String roleId, String[] userGroupCodes);

  /**
   * 解除指定角色和用户组绑定关系
   * @param roleId
   * @param userGroupCodes
   */
  void unbindUserGroups(String roleId, String[] userGroupCodes);
  /**
   * 给指定id的角色重新进行用户组绑定，按照最新给定的用户组进行绑定
   * @param roleId
   * @param userGroupCodes
   */
  void reBindUserGroup(String roleId, String[] userGroupCodes);
  /**
   * 将指定用户组绑定一个或多个角色
   * @param userGroupCode
   * @param roleIds
   */
  void bindUserGroupRoles(String userGroupCode, String[] roleIds);
  /**
   * 解除指定用户组与角色绑定关系
   * @param userGroupCode
   * @param roleIds
   */
  void unbindUserGroupRoles(String userGroupCode, String[] roleIds);
  /**
   * 给指定编码的用户组重新进行角色绑定，按照最新给定的角色进行绑定
   * @param userGroupCode
   * @param roleCodes
   */
  void reBindUserGroupRoles(String userGroupCode, String[] roleCodes);
  /**
   * 根据角色编码查询绑定用户组
   * @param roleCode
   * @return
   */
  List<UserGroupVo> findByRoleCode(String roleCode);
}
