package com.bizunited.platform.rbac.server.configuration;

import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.spring.session.config.EnableRedissonHttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * redis客户端的配置信息，基于Redisson
 * @author yinwenjie
 */
@Configuration
@EnableConfigurationProperties(RedisCustomProperties.class)
@EnableRedissonHttpSession(keyPrefix="spring:session:sessions:", maxInactiveIntervalInSeconds = 28800)
public class RedissonCustomConfig {
  @Autowired
  private RedisCustomProperties redisCustomProperties;

  private static final String REDIS_PREFIX = "redis://";
  
  /**
   * 默认构建，使用该starter的业务系统可以进行修改
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public RedissonClient getRedissonClient() {
    Config config = new Config();
    RedissonClient redissonClient = null;
    // 如果条件成立，说明是单节点配置模式
    if(StringUtils.equals(redisCustomProperties.getModel(), "single")) {
      SingleServerConfig serverConfig = config.useSingleServer()
          .setAddress(REDIS_PREFIX + redisCustomProperties.getAddress()[0])
          .setDatabase(redisCustomProperties.getDatabase())
          .setTimeout(redisCustomProperties.getTimeout())
          .setRetryAttempts(redisCustomProperties.getRetryAttempts())
          .setRetryInterval(redisCustomProperties.getRetryInterval())
          .setPingConnectionInterval(redisCustomProperties.getPingConnectionInterval())
          .setConnectionPoolSize(redisCustomProperties.getConnectionPoolSize())
          .setConnectionMinimumIdleSize(redisCustomProperties.getConnectionMinimumIdleSize());
      if(!StringUtils.isBlank(redisCustomProperties.getPassword())) {
        serverConfig.setPassword(redisCustomProperties.getPassword());
      }
      redissonClient = Redisson.create(config);
    }

    // 如果条件成立，说明是集群模式配置模式
    if(StringUtils.equals(redisCustomProperties.getModel(), "cluster")) {
      ClusterServersConfig serverConfig = config.useClusterServers()
              .addNodeAddress(redisCustomProperties.getAddress())
              .setTimeout(redisCustomProperties.getTimeout())
              .setRetryAttempts(redisCustomProperties.getRetryAttempts())
              .setRetryInterval(redisCustomProperties.getRetryInterval())
              .setPingConnectionInterval(redisCustomProperties.getPingConnectionInterval())
              .setMasterConnectionPoolSize(redisCustomProperties.getConnectionPoolSize())
              .setSlaveConnectionPoolSize(redisCustomProperties.getConnectionPoolSize())
              .setMasterConnectionMinimumIdleSize(redisCustomProperties.getConnectionMinimumIdleSize())
              .setSlaveConnectionMinimumIdleSize(redisCustomProperties.getConnectionMinimumIdleSize());
      if(!StringUtils.isBlank(redisCustomProperties.getPassword())) {
        serverConfig.setPassword(redisCustomProperties.getPassword());
      }
      redissonClient = Redisson.create(config);
    }

    // 如果条件成立，说明是哨兵模式配置模式
    if(StringUtils.equals(redisCustomProperties.getModel(), "sentinel")) {
      SentinelServersConfig serverConfig = config.useSentinelServers()
              .addSentinelAddress(redisCustomProperties.getAddress())
              .setDatabase(redisCustomProperties.getDatabase())
              .setTimeout(redisCustomProperties.getTimeout())
              .setRetryAttempts(redisCustomProperties.getRetryAttempts())
              .setRetryInterval(redisCustomProperties.getRetryInterval())
              .setPingConnectionInterval(redisCustomProperties.getPingConnectionInterval())
              .setMasterConnectionPoolSize(redisCustomProperties.getConnectionPoolSize())
              .setSlaveConnectionPoolSize(redisCustomProperties.getConnectionMinimumIdleSize());
      if(!StringUtils.isBlank(redisCustomProperties.getPassword())) {
        serverConfig.setPassword(redisCustomProperties.getPassword());
      }
      redissonClient = Redisson.create(config);
    }
    return redissonClient;
  }
}