package com.bizunited.platform.rbac.server.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 角色类型枚举
 *
 * @Author: chenrong
 * @Date: 2020/10/27 9:59
 */
public enum RoleTypeEnum {
  BUSINESS("T001", "业务角色"),
  MANAGE("T002", "管理角色"),
  ;
  /** 类型 **/
  private String type;
 /** 描述 **/
  private String desc;

  /**
   * 根据类型获取枚举
   * @param type
   * @return
   */
  public static RoleTypeEnum valueOfType(String type) {
    RoleTypeEnum[] roleTypeEnums = RoleTypeEnum.values();
    if (roleTypeEnums == null || StringUtils.isBlank(type)) {
      return null;
    }
    for (RoleTypeEnum roleTypeEnum : roleTypeEnums) {
      if (StringUtils.equals(type, roleTypeEnum.getType())) {
        return roleTypeEnum;
      }
    }
    return null;
  }

  /**
   * 根据描述获取枚举
   * @param desc
   * @return
   */
  public static RoleTypeEnum valueOfDesc(String desc) {
    RoleTypeEnum[] roleTypeEnums = RoleTypeEnum.values();
    if (roleTypeEnums == null || StringUtils.isBlank(desc)) {
      return null;
    }
    for (RoleTypeEnum roleTypeEnum : roleTypeEnums) {
      if(StringUtils.equals(roleTypeEnum.getDesc(), desc)){
        return roleTypeEnum;
      }
    }
    return null;
  }

  RoleTypeEnum(String type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  public String getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }
}
