/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.RoleUserMappingService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.user.UserEventListener;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="roleInitBindListener")
public class RoleInitBindListener
implements UserEventListener {
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleUserMappingService roleUserMappingService;
    private static final String BASEROLE = "BASEROLE";

    @Transactional
    public void onUserCreated(UserVo user) {
        Validate.notNull((Object)user, (String)"\u53d1\u751f\u521b\u5efa\u7684\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        String account = user.getAccount();
        Validate.notBlank((CharSequence)account, (String)"\u53d1\u751f\u521b\u5efa\u7684\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Set<RoleVo> baseRoles = this.roleService.findByRoleNames(Sets.newHashSet((Object[])new String[]{BASEROLE}));
        Validate.notEmpty(baseRoles, (String)"\u672a\u5728\u672c\u5730\u7cfb\u7edf\u53d1\u73b0\u7279\u5b9a\u7684\u57fa\u7840\u89d2\u8272BASEROLE\u7684\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u672c\u5730\u7cfb\u7edf\u89d2\u8272\u914d\u7f6e\u60c5\u51b5!!", (Object[])new Object[0]);
        Set<RoleVo> roles = this.roleService.findByUserAccount(account);
        if (!CollectionUtils.isEmpty(roles)) {
            return;
        }
        this.roleUserMappingService.bindUserRoles(account, new String[]{BASEROLE});
    }

    public void onUserUpgraded(UserVo user) {
    }
}

