package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.RoleUserMappingService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.user.UserEventListener;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.List;
import java.util.Set;

@Component("roleInitBindListener")
public class RoleInitBindListener implements UserEventListener {

  @Autowired
  private RoleService roleService;
  @Autowired
  private RoleUserMappingService roleUserMappingService;
  
  /**
   * 基础用户信息
   */
  private static final String BASEROLE = "BASEROLE";
  
  /**
   * 当本地系统被通知在本地创建了一个新的用户信息时
   * （无论这个通知的上层逻辑是在远程创建了一个用户还是在本地创建了一个用户）</p>
   * 该方法都负责为这个用户绑定一个本地的基础角色信息（BaseRole）</br>
   * 
   * 前提是BaseRole这个角色在本地是存在的
   */
  @Override
  @Transactional
  public void onUserCreated(UserVo user) {
    Validate.notNull(user , "发生创建的用户信息不能为null");
    String account = user.getAccount();
    Validate.notBlank(account , "发生创建的用户信息不能为null");
    // 确定基础角色信息是否存在
    Set<RoleVo> baseRoles = this.roleService.findByRoleNames(Sets.newHashSet(BASEROLE));
    Validate.notEmpty(baseRoles, "未在本地系统发现特定的基础角色BASEROLE的信息，请检查本地系统角色配置情况!!");
    
    // 判定当前账户和角色是否存在绑定关系，如果存在则不用在绑定了
    // 这个场景在“用户模块以微服务中心工作”的场景下可能出现的
    List<RoleVo> roles = this.roleService.findAllByUserAccount(account);
    if(!CollectionUtils.isEmpty(roles)) {
      return;
    }
    // 进行绑定
    this.roleUserMappingService.bindUserRoles(account, new String[] {BASEROLE});
  }

  @Override
  public void onUserUpgraded(UserVo user) {
    // 该监听器不需要对用户信息变更进行任何处理
  }
}