package com.bizunited.platform.rbac.server.vo;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 角色与用户的关联信息Vo
 * @Author: zengxingwang
 * @Date: 2020/3/30 15:28
 */
@ApiModel("角色与用户的关联信息Vo")
public class RoleUserMappingVo extends UuidVo {

  private static final long serialVersionUID = 7649043001002183691L;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  @SaturnColumn(description="角色编码")
  private RoleVo role;

  /**
   * 用户账号
   */
  @ApiModelProperty(name="userAccount" , value="用户账号" , required=true)
  @SaturnColumn(description="用户账号")
  private String userAccount;

  /**
   * 项目名称
   */
  @ApiModelProperty(name = "projectName", value = "projectName")
  @SaturnColumn(description = "项目名称")
  private String projectName = ApplicationContextUtils.getProjectName();

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public RoleVo getRole() {
    return role;
  }

  public void setRole(RoleVo role) {
    this.role = role;
  }

  public String getUserAccount() {
    return userAccount;
  }

  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }
}
