/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.position.PositionEventListener;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserRelationVo;
import java.util.ArrayList;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="RolePositionEventListenerImpl")
public class RolePositionBindListener
implements PositionEventListener {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private RolePositionMappingService rolePositionMappingService;

    @Transactional
    public void onPositionCreate(UserRelationVo userRelation) {
        ArrayList<String> roleIds = new ArrayList<String>();
        PositionVo position = this.positionService.findByCode(userRelation.getPositionCode());
        Validate.notNull((Object)position, (String)"\u7f16\u7801[%s]\u7684\u804c\u4f4d\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{userRelation.getPositionCode()});
        RoleVo authorityRole = this.roleService.findByCode(userRelation.getAuthorityRoleCode());
        Validate.notNull((Object)((Object)authorityRole), (String)"\u7f16\u7801[%s]\u7684\u89d2\u8272\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{userRelation.getAuthorityRoleCode()});
        roleIds.add(authorityRole.getId());
        this.rolePositionMappingService.rebindPositionRoles(position.getCode(), roleIds.toArray(new String[roleIds.size()]));
    }
}

