package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.vo.PositionLevelSimpleVo;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;

/**
 * @author: weikangning
 * @Date: 2020/8/16 21:26
 * @Description: 角色和职位级别映射信息服务
 */
public interface RolePositionLevelMappingService {
  /**
   * 将指定职位级别绑定一个或多个角色
   *
   * @param positionLevelCode
   * @param roleCodes
   */
  void bindPositionLevelRoles(String positionLevelCode, String[] roleCodes);

  /**
   * 将指定职位级别重新绑定一个或多个角色
   *
   * @param positionLevelCode
   * @param roleCodes
   */
  void rebindPositionLevelRoles(String positionLevelCode, String[] roleCodes);

  /**
   * 将指定职位级别解除一个或多个角色的绑定
   *
   * @param positionLevelCode
   * @param roleCodes
   */
  void unbindPositionLevelRoles(String positionLevelCode, String[] roleCodes);

  /**
   * @Description :解绑一个或多个职位级别的全部角色
   * @Param:
   * @Return:
   * @Author: weikangning
   * @Date: 2020/8/27 17:40
   */
  void unbindPositionLevels(String[] positionLevelCodes);

  /**
   * 根据职级Id,删除职级、解绑角色
   * @param id 职级主键
   */
  void deletePositionLevelUnbindRole(String id);

  /**
   * 批量根据职级Id,删除职级、解绑角色
   * @param ids 职级主键列表
   */
  void deletePositionLevelsUnbindRole(String[] ids);

  /**
   * 分页查询职级
   * @param condition
   * @param pageable
   * @return
   */
  Page<PositionLevelSimpleVo> findByConditions(Map<String,Object> condition, Pageable pageable);

  /**
   * 条件查询
   * @param name
   * @param roleName
   * @return
   */
  List<PositionLevelSimpleVo> findByNameAndRoleName(String name, String roleName);

  /**
   * 根据职级编码查询
   * @param positionLevelCode
   * @return
   */
  List<PositionLevelSimpleVo> findByPositionLevelCode(String positionLevelCode);

  /**
   * 根据职级编码查询角色列表
   * @param positionLevelCode
   * @return
   */
  List<RoleVo> findRolesByPositionLevelCode(String positionLevelCode);
}
