package com.bizunited.platform.rbac.server.vo;

import com.bizunited.platform.common.vo.FormInstanceUuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation.RelationType;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Set;

/**
 * 博智中间件平台用户角色信息描述
 * @author yinwenjie
 * @version V1.1
 */
@SaturnEntity(description="角色信息" , name="RoleVo")
public class RoleVo extends FormInstanceUuidVo {
  
  private static final long serialVersionUID = 6432461588626210634L;

  /** 角色的业务编号. **/
  @SaturnColumn(description="角色编码", length = 64, nullable = false, unique = true)
  private String roleCode = "";
  /** 角色名称(只能是英文，且保存时必须是大写). **/
  @SaturnColumn(description="角色名称", length = 64, nullable = false, unique = true)
  private String roleName = "";
  /** 
   * 角色类型编号 
   * T001：业务角色
   * T002：管理角色
   */
  @SaturnColumn(description="角色类型编号" , length = 64, nullable = false)
  private String roleType = "";
  /** 状态 1正常, 0禁用(枚举). **/
  @SaturnColumn(description="角色状态", nullable = false)
  private Integer tstatus = 1;
  /** 创建时间. **/
  @SaturnColumn(description="创建时间", nullable = false)
  private Date createDate = new Date();
  /**
   * 是否系统角色，如果是系统角色就不允许操作者删除
   */
  @SaturnColumn(description="是否系统角色", nullable = false)
  private Boolean isDeny = false;
  /**
   * 角色后默认页面跳转路径
   */
  @SaturnColumn(description = "角色默认页面跳转路径" ,length = 512)
  private String defaultUrl;
  /** 备注.角色信息说明，备注信息不用填写，但是至少需要在写操作时传入空字符串 **/
  @SaturnColumn(description="角色备注", length = 64, nullable = true)
  private String comment = "";
  /**
   * 这个角色已经绑定的用户信息
   */
  @SaturnColumn(description="角色已经绑定的用户信息")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<UserVo> users;

  /**
   * 角色和用户的关联信息
   */
  @SaturnColumnRelation(type=RelationType.OneToMany)
  @SaturnColumn(description="角色和用户的关联信息")
  private Set<RoleUserMappingVo> roleUserMapping;

  /** 角色和功能菜单的对应关系. **/
  @SaturnColumn(description="角色和功能菜单的对应关系")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<CompetenceVo> competences;

  /** 角色和按钮的对应关系. **/
  @SaturnColumn(description="角色和按钮的对应关系")
  @SaturnColumnRelation(type=RelationType.ManyToMany , master=true)
  private Set<ButtonVo> buttons;

  @SaturnColumn(description="角色的父级")
  @SaturnColumnRelation(type=RelationType.ManyToOne)
  private RoleVo parent;
  @SaturnColumnRelation(type=RelationType.OneToMany)
  @SaturnColumn(description="角色的子级")
  private Set<RoleVo> children;
  /**来源**/
  private String source;

  /**
   * 项目名称
   */
  @ApiModelProperty(name = "projectName", value = "projectName")
  @SaturnColumn(description = "项目名称")
  private String projectName;

  /**
   * 扩展字段1
   */
  @ApiModelProperty(name="extend1", value="扩展字段1", required=false)
  @SaturnColumn(description="扩展字段1")
  private String extend1;

  /**
   * 扩展字段2
   */
  @ApiModelProperty(name="extend2", value="扩展字段2", required=false)
  @SaturnColumn(description="扩展字段2")
  private String extend2;

  /**
   * 扩展字段3
   */
  @ApiModelProperty(name="extend3", value="扩展字段3", required=false)
  @SaturnColumn(description="扩展字段3")
  private String extend3;

  /**
   * 扩展字段4
   */
  @ApiModelProperty(name="extend4", value="扩展字段4", required=false)
  @SaturnColumn(description="扩展字段4")
  private String extend4;

  /**
   * 扩展字段5
   */
  @ApiModelProperty(name="extend5", value="扩展字段5", required=false)
  @SaturnColumn(description="扩展字段5")
  private String extend5;

  /**
   * 扩展字段6
   */
  @ApiModelProperty(name="extend6", value="扩展字段6", required=false)
  @SaturnColumn(description="扩展字段6")
  private String extend6;

  /**
   * 扩展字段7
   */
  @ApiModelProperty(name="extend7", value="扩展字段7", required=false)
  @SaturnColumn(description="扩展字段7")
  private String extend7;

  /**
   * 扩展字段8
   */
  @ApiModelProperty(name="extend8", value="扩展字段8", required=false)
  @SaturnColumn(description="扩展字段8")
  private String extend8;

  /**
   * 扩展字段9
   */
  @ApiModelProperty(name="extend9", value="扩展字段9", required=false)
  @SaturnColumn(description="扩展字段9")
  private String extend9;

  /**
   * 扩展字段10
   */
  @ApiModelProperty(name="extend10", value="扩展字段10", required=false)
  @SaturnColumn(description="扩展字段10")
  private String extend10;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public RoleVo getParent() {
    return parent;
  }

  public void setParent(RoleVo parent) {
    this.parent = parent;
  }

  public Set<RoleVo> getChildren() {
    return children;
  }

  public void setChildren(Set<RoleVo> children) {
    this.children = children;
  }

  public String getRoleCode() {
    return roleCode;
  }
  public void setRoleCode(String roleCode) {
    this.roleCode = roleCode;
  }
  public String getRoleName() {
    return roleName;
  }
  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }
  public String getRoleType() {
    return roleType;
  }
  public void setRoleType(String roleType) {
    this.roleType = roleType;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Date getCreateDate() {
    return createDate;
  }
  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }
  public Boolean getIsDeny() {
    return isDeny;
  }
  public void setIsDeny(Boolean isDeny) {
    this.isDeny = isDeny;
  }
  public String getDefaultUrl() {
    return defaultUrl;
  }
  public void setDefaultUrl(String defaultUrl) {
    this.defaultUrl = defaultUrl;
  }
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }
  public Set<UserVo> getUsers() {
    return users;
  }
  public void setUsers(Set<UserVo> users) {
    this.users = users;
  }

  public Set<ButtonVo> getButtons() {
    return buttons;
  }

  public void setButtons(Set<ButtonVo> buttons) {
    this.buttons = buttons;
  }

  public Boolean getDeny() {
    return isDeny;
  }

  public void setDeny(Boolean deny) {
    isDeny = deny;
  }
  public Set<CompetenceVo> getCompetences() {
    return competences;
  }
  public void setCompetences(Set<CompetenceVo> competences) {
    this.competences = competences;
  }

  public Set<RoleUserMappingVo> getRoleUserMapping() {
    return roleUserMapping;
  }

  public void setRoleUserMapping(Set<RoleUserMappingVo> roleUserMapping) {
    this.roleUserMapping = roleUserMapping;
  }

  public String getExtend1() {
    return extend1;
  }

  public void setExtend1(String extend1) {
    this.extend1 = extend1;
  }

  public String getExtend2() {
    return extend2;
  }

  public void setExtend2(String extend2) {
    this.extend2 = extend2;
  }

  public String getExtend3() {
    return extend3;
  }

  public void setExtend3(String extend3) {
    this.extend3 = extend3;
  }

  public String getExtend4() {
    return extend4;
  }

  public void setExtend4(String extend4) {
    this.extend4 = extend4;
  }

  public String getExtend5() {
    return extend5;
  }

  public void setExtend5(String extend5) {
    this.extend5 = extend5;
  }

  public String getExtend6() {
    return extend6;
  }

  public void setExtend6(String extend6) {
    this.extend6 = extend6;
  }

  public String getExtend7() {
    return extend7;
  }

  public void setExtend7(String extend7) {
    this.extend7 = extend7;
  }

  public String getExtend8() {
    return extend8;
  }

  public void setExtend8(String extend8) {
    this.extend8 = extend8;
  }

  public String getExtend9() {
    return extend9;
  }

  public void setExtend9(String extend9) {
    this.extend9 = extend9;
  }

  public String getExtend10() {
    return extend10;
  }

  public void setExtend10(String extend10) {
    this.extend10 = extend10;
  }
}