/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.service.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.rbac.server.service.ButtonService;
import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.vo.ButtonVo;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="CompetenceInitProcess")
public class CompetenceInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceInitProcess.class);
    @Autowired(required=false)
    private ButtonService buttonService;
    @Autowired(required=false)
    private CompetenceService competenceService;
    @Autowired
    private ApplicationContext applicationContext;

    public int sort() {
        return 0;
    }

    public boolean doProcess() {
        long count = this.competenceService.countByViewItem(1);
        return count == 0L;
    }

    @Transactional
    public void init() {
        try {
            Object[] resources = this.applicationContext.getResources("classpath*:/competences/**.json");
            if (ArrayUtils.isEmpty((Object[])resources)) {
                return;
            }
            for (Object resource : resources) {
                try (InputStream is = resource.getInputStream();){
                    this.initCompetences(is);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("\u8bfb\u53d6\u83dc\u5355\u6587\u4ef6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u83dc\u5355\u6587\u4ef6");
        }
    }

    private void initCompetences(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        if (this.competenceService == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line = bufferedReader.readLine();
            while (line != null) {
                sb.append(line);
                line = bufferedReader.readLine();
            }
        }
        String json = sb.toString();
        if (StringUtils.isBlank((CharSequence)json)) {
            LOGGER.warn("\u521d\u59cb\u5316\u83dc\u5355json\u4e3a\u7a7a\uff01\uff01");
            return;
        }
        JSONArray competences = JSON.parseArray((String)json);
        this.initCompetences(null, competences);
    }

    private void initCompetences(CompetenceVo parent, JSONArray competences) {
        if (CollectionUtils.isEmpty((Collection)competences)) {
            return;
        }
        for (Object object : competences) {
            JSONObject competenceJson = JSON.parseObject((String)object.toString());
            CompetenceVo competence = (CompetenceVo)JSON.parseObject((String)competenceJson.toJSONString(), CompetenceVo.class);
            CompetenceVo oldCompetence = parent != null ? this.competenceService.findByCommentAndViewItemAndParent(competence.getComment(), 1, parent.getId()) : this.competenceService.findByCommentAndViewItemAndNullParent(competence.getComment(), 1);
            if (oldCompetence == null) {
                competence.setCreateDate(new Date());
                competence.setModifyDate(new Date());
                competence.setTstatus(1);
                competence.setParent(parent);
                oldCompetence = this.competenceService.create(competence);
            }
            this.initButtons(oldCompetence, competence.getButtons());
            if (!competenceJson.containsKey((Object)"competences")) continue;
            this.initCompetences(oldCompetence, competenceJson.getJSONArray("competences"));
        }
    }

    private void initButtons(CompetenceVo competence, Set<ButtonVo> buttons) {
        if (this.buttonService == null || CollectionUtils.isEmpty(buttons)) {
            return;
        }
        for (ButtonVo button : buttons) {
            Set<CompetenceVo> competencesJson = button.getCompetences();
            ButtonVo oldButton = this.buttonService.findDetailsByCode(button.getCode());
            if (oldButton == null) {
                button.setCompetence(competence);
                button.setSystem(true);
                button.setCompetences(null);
                oldButton = this.buttonService.create(button);
            } else {
                Validate.isTrue((boolean)competence.getId().equals(oldButton.getCompetence().getId()), (String)"\u91cd\u590d\u7684\u6309\u94ae\u6bd4\u7f16\u7801\u3010%s\u3011,\u8bf7\u68c0\u67e5", (Object[])new Object[]{button.getCode()});
            }
            if (CollectionUtils.isEmpty(competencesJson)) continue;
            this.initButtonCompetences(oldButton, competencesJson);
        }
    }

    private void initButtonCompetences(ButtonVo button, Set<CompetenceVo> competencesJson) {
        if (CollectionUtils.isEmpty(competencesJson)) {
            return;
        }
        if (button == null) {
            return;
        }
        HashMap<String, CompetenceVo> competencesMap = new HashMap<String, CompetenceVo>();
        Set<CompetenceVo> buttonCompetences = this.competenceService.findByButtonId(button.getId());
        if (buttonCompetences == null) {
            buttonCompetences = new HashSet<CompetenceVo>();
            button.setCompetences(buttonCompetences);
        } else {
            for (CompetenceVo entity : buttonCompetences) {
                competencesMap.put(entity.getId(), entity);
            }
        }
        for (CompetenceVo competence : competencesJson) {
            CompetenceVo oldCompetence = this.competenceService.findByResourceAndMethods(competence.getResource(), competence.getMethods());
            if (oldCompetence == null) {
                LOGGER.warn("\u672a\u627e\u5230\u63a5\u53e3\u8def\u5f84\u3010{}\u3011,\u8bf7\u6c42\u65b9\u6cd5\u3010{}\u3011\uff0c\u8bf7\u68c0\u67e5!", (Object)competence.getResource(), (Object)competence.getMethods());
                continue;
            }
            if (competencesMap.containsKey(oldCompetence.getId())) continue;
            buttonCompetences.add(oldCompetence);
            competencesMap.put(oldCompetence.getId(), oldCompetence);
        }
        this.buttonService.reBindCompetences(button, buttonCompetences);
    }
}

