/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.position.PositionLevelEventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="PositionLevelEventListenerImpl")
public class RolePositionLevelBindListener
implements PositionLevelEventListener {
    @Autowired
    private RoleService roleService;
    @Autowired
    private RolePositionLevelMappingService rolePositionLevelMappingService;

    @Transactional
    public void onPositionLevelCreate(String positionLevelCode, String[] roleIds) {
        Validate.notEmpty((Object[])roleIds, (String)"\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<String> roleIdList = new ArrayList<String>(Arrays.asList(roleIds));
        Set<RoleVo> roleVos = this.roleService.findByIds(roleIdList);
        Validate.notEmpty(roleVos, (String)"\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u6307\u5b9a\u7684\u804c\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.rolePositionLevelMappingService.bindPositionLevelRoles(positionLevelCode, roleIds);
    }

    @Transactional
    public void onPositionLevelUpdate(String positionLevelCode, String[] roleIds) {
        Validate.notEmpty((Object[])roleIds, (String)"\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<String> roleIdList = new ArrayList<String>(Arrays.asList(roleIds));
        Set<RoleVo> roleVos = this.roleService.findByIds(roleIdList);
        Validate.notEmpty(roleVos, (String)"\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u6307\u5b9a\u7684\u804c\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.rolePositionLevelMappingService.rebindPositionLevelRoles(positionLevelCode, roleIds);
    }
}

