package com.bizunited.platform.rbac.server.service.event;

import com.bizunited.platform.rbac.server.service.RolePositionMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.position.PositionEventListener;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserRelationVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;

/**
 * 角色绑定职位监听处理
 * @Author: zengxingwang
 * @Date: 2020/9/24 11:23
 */
@Component("RolePositionEventListenerImpl")
public class RolePositionBindListener implements PositionEventListener {

  @Autowired
  private RoleService roleService;
  @Autowired
  private PositionService positionService;
  @Autowired
  private RolePositionMappingService rolePositionMappingService;

  /**
   * 当本地系统被通知在本地人区创建了一个新的用户信息时，职位和角色关系发生变化，重新绑定职位和角色关系
   */
  @Override
  @Transactional
  public void onPositionCreate(UserRelationVo userRelation) {
    List<String> roleIds = new ArrayList<>();
    PositionVo position = positionService.findByCode(userRelation.getPositionCode());
    Validate.notNull(position, "编码[%s]的职位未找到，请检查", userRelation.getPositionCode());
    RoleVo authorityRole = roleService.findByCode(userRelation.getAuthorityRoleCode());
    Validate.notNull(authorityRole, "编码[%s]的角色未找到，请检查", userRelation.getAuthorityRoleCode());
    roleIds.add(authorityRole.getId());
    //绑定
    rolePositionMappingService.rebindPositionRoles(position.getCode(), roleIds.toArray(new String[roleIds.size()]));
  }
}
